/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.mysqlflexibleserver.models.Backup;
import com.azure.resourcemanager.mysqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.mysqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.mysqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.mysqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.mysqlflexibleserver.models.Storage;
import java.io.IOException;

public final class ServerPropertiesForUpdate
implements JsonSerializable<ServerPropertiesForUpdate> {
    private String administratorLoginPassword;
    private Storage storage;
    private Backup backup;
    private HighAvailability highAvailability;
    private MaintenanceWindow maintenanceWindow;
    private ReplicationRole replicationRole;
    private DataEncryption dataEncryption;

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ServerPropertiesForUpdate withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public Storage storage() {
        return this.storage;
    }

    public ServerPropertiesForUpdate withStorage(Storage storage) {
        this.storage = storage;
        return this;
    }

    public Backup backup() {
        return this.backup;
    }

    public ServerPropertiesForUpdate withBackup(Backup backup) {
        this.backup = backup;
        return this;
    }

    public HighAvailability highAvailability() {
        return this.highAvailability;
    }

    public ServerPropertiesForUpdate withHighAvailability(HighAvailability highAvailability) {
        this.highAvailability = highAvailability;
        return this;
    }

    public MaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public ServerPropertiesForUpdate withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        this.maintenanceWindow = maintenanceWindow;
        return this;
    }

    public ReplicationRole replicationRole() {
        return this.replicationRole;
    }

    public ServerPropertiesForUpdate withReplicationRole(ReplicationRole replicationRole) {
        this.replicationRole = replicationRole;
        return this;
    }

    public DataEncryption dataEncryption() {
        return this.dataEncryption;
    }

    public ServerPropertiesForUpdate withDataEncryption(DataEncryption dataEncryption) {
        this.dataEncryption = dataEncryption;
        return this;
    }

    public void validate() {
        if (this.storage() != null) {
            this.storage().validate();
        }
        if (this.backup() != null) {
            this.backup().validate();
        }
        if (this.highAvailability() != null) {
            this.highAvailability().validate();
        }
        if (this.maintenanceWindow() != null) {
            this.maintenanceWindow().validate();
        }
        if (this.dataEncryption() != null) {
            this.dataEncryption().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeJsonField("storage", (JsonSerializable)this.storage);
        jsonWriter.writeJsonField("backup", (JsonSerializable)this.backup);
        jsonWriter.writeJsonField("highAvailability", (JsonSerializable)this.highAvailability);
        jsonWriter.writeJsonField("maintenanceWindow", (JsonSerializable)this.maintenanceWindow);
        jsonWriter.writeStringField("replicationRole", this.replicationRole == null ? null : this.replicationRole.toString());
        jsonWriter.writeJsonField("dataEncryption", (JsonSerializable)this.dataEncryption);
        return jsonWriter.writeEndObject();
    }

    public static ServerPropertiesForUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (ServerPropertiesForUpdate)jsonReader.readObject(reader -> {
            ServerPropertiesForUpdate deserializedServerPropertiesForUpdate = new ServerPropertiesForUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.administratorLoginPassword = reader.getString();
                    continue;
                }
                if ("storage".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.storage = Storage.fromJson(reader);
                    continue;
                }
                if ("backup".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.backup = Backup.fromJson(reader);
                    continue;
                }
                if ("highAvailability".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.highAvailability = HighAvailability.fromJson(reader);
                    continue;
                }
                if ("maintenanceWindow".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.maintenanceWindow = MaintenanceWindow.fromJson(reader);
                    continue;
                }
                if ("replicationRole".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.replicationRole = ReplicationRole.fromString(reader.getString());
                    continue;
                }
                if ("dataEncryption".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.dataEncryption = DataEncryption.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerPropertiesForUpdate;
        });
    }
}

