/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.ConfigurationProperties;
import com.azure.resourcemanager.mysqlflexibleserver.models.ConfigurationSource;
import com.azure.resourcemanager.mysqlflexibleserver.models.IsConfigPendingRestart;
import com.azure.resourcemanager.mysqlflexibleserver.models.IsDynamicConfig;
import com.azure.resourcemanager.mysqlflexibleserver.models.IsReadOnly;
import java.io.IOException;

public final class ConfigurationInner
extends ProxyResource {
    private ConfigurationProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    public ConfigurationInner withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public String defaultValue() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultValue();
    }

    public String dataType() {
        return this.innerProperties() == null ? null : this.innerProperties().dataType();
    }

    public String allowedValues() {
        return this.innerProperties() == null ? null : this.innerProperties().allowedValues();
    }

    public ConfigurationSource source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    public ConfigurationInner withSource(ConfigurationSource source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    public IsReadOnly isReadOnly() {
        return this.innerProperties() == null ? null : this.innerProperties().isReadOnly();
    }

    public IsConfigPendingRestart isConfigPendingRestart() {
        return this.innerProperties() == null ? null : this.innerProperties().isConfigPendingRestart();
    }

    public IsDynamicConfig isDynamicConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().isDynamicConfig();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigurationInner)((Object)jsonReader.readObject(reader -> {
            ConfigurationInner deserializedConfigurationInner = new ConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConfigurationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedConfigurationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedConfigurationInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedConfigurationInner.innerProperties = ConfigurationProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedConfigurationInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigurationInner;
        }));
    }
}

