/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.api;

import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseStatus;
import com.dbeaver.lm.api.LMLicenseType;
import com.dbeaver.lm.api.LMProduct;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class LMUtils {
    private static final Logger log = Logger.getLogger("LMUtils");
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final SimpleDateFormat HR_DATE_FORMAT = new SimpleDateFormat("yyyy-MMM-dd");
    private static final SecureRandom RND = new SecureRandom();
    private static short licenseCounter = (short)RND.nextInt(Short.MAX_VALUE);

    public static byte[] readEncryptedString(InputStream stream) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStreamReader reader = new InputStreamReader(stream);){
            return LMUtils.readEncryptedString(reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] readEncryptedString(Reader reader) throws IOException {
        StringBuilder result = new StringBuilder(4000);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) {
                    break;
                }
                if (line.startsWith("-") || line.startsWith("#")) continue;
                result.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String licenseEncoded = result.toString();
        licenseEncoded = licenseEncoded.replaceAll("\\s", "");
        return Base64.getDecoder().decode(licenseEncoded);
    }

    public static String generateLicenseId(LMProduct product) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(new Date());
        int dayOfYear = cal.get(6);
        int year = cal.get(1);
        int time = cal.get(11) * 60 + cal.get(12);
        short counter = LMUtils.getLicenseCounter();
        Object licenseId = product.getPrefix() + "-" + LMUtils.getNumString(dayOfYear, 2) + LMUtils.getNumString(year, 3) + LMUtils.getNumString(time, 3) + "-" + LMUtils.getNumString(counter, 4);
        if (((String)licenseId).length() > 16) {
            licenseId = ((String)licenseId).substring(0, 16);
        }
        return licenseId;
    }

    private static String getNumString(int value, int minDigits) {
        Object str = Integer.toString(value, 35).toUpperCase(Locale.ENGLISH);
        while (((String)str).length() < minDigits) {
            str = "Z" + (String)str;
        }
        char[] chars = ((String)str).toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '0' || chars[i] == '0') {
                chars[i] = 90;
            }
            ++i;
        }
        return new String(chars);
    }

    private static synchronized short getLicenseCounter() {
        licenseCounter = (short)(licenseCounter + 1);
        return licenseCounter;
    }

    @Nullable
    public static Date getDateFromBuffer(@NotNull ByteBuffer buffer) {
        long time = buffer.getLong();
        return time == 0L ? null : new Date(time);
    }

    @NotNull
    public static String getStringFromBuffer(@NotNull ByteBuffer buffer, int length) {
        byte[] data = new byte[length];
        buffer.get(data);
        return new String(data, StandardCharsets.UTF_8).trim();
    }

    public static void putDateToBuffer(@NotNull ByteBuffer buffer, @Nullable Date date) {
        buffer.putLong(date == null ? 0L : date.getTime());
    }

    public static void putStringToBuffer(@NotNull ByteBuffer buffer, @Nullable String value, int length) {
        buffer.put(LMUtils.getStringData(value, length));
    }

    @NotNull
    private static byte[] getStringData(@Nullable String value, int length) {
        byte[] bytes = value == null ? new byte[]{} : value.getBytes(StandardCharsets.UTF_8);
        byte[] data = Arrays.copyOf(bytes, length);
        Arrays.fill(data, Math.min(bytes.length, length), length, (byte)32);
        return data;
    }

    public static boolean isUnlimitedUsersLicense(@NotNull LMLicense productLicense) {
        return productLicense.getLicenseType() == LMLicenseType.ULTIMATE || (productLicense.getFlags() & 0x100L) != 0L;
    }

    public static void writeStringToBuffer(@NotNull ByteArrayOutputStream outBuffer, @Nullable String value, int length) {
        outBuffer.writeBytes(LMUtils.getStringData(value, length));
    }

    public static void writeDateToBuffer(@NotNull ByteArrayOutputStream outBuffer, @Nullable Date date) {
        long value = date == null ? 0L : date.getTime();
        LMUtils.writeLongToBuffer(outBuffer, value);
    }

    public static void writeLongToBuffer(@NotNull ByteArrayOutputStream outBuffer, long value) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[8]);
        buffer.putLong(value);
        outBuffer.writeBytes(buffer.array());
    }

    public static void writeShortToBuffer(@NotNull ByteArrayOutputStream outBuffer, short value) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[2]);
        buffer.putShort(value);
        outBuffer.writeBytes(buffer.array());
    }

    public static void writeIntToBuffer(@NotNull ByteArrayOutputStream outBuffer, int value) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[4]);
        buffer.putInt(value);
        outBuffer.writeBytes(buffer.array());
    }

    @Nullable
    public static String truncateString(@Nullable String str, int maxLength) {
        if (str != null && str.length() > maxLength) {
            return str.substring(0, maxLength);
        }
        return str;
    }

    @NotNull
    public static String splitLines(String bigString, int lineLength) {
        return bigString.replaceAll("(.{" + lineLength + "})", "$1\n");
    }

    public static boolean isValidLicenseStatus(@NotNull String licenseStatusText) {
        int divPos;
        String licenseStatusString;
        block5: {
            try {
                BufferedReader br = new BufferedReader(new StringReader(licenseStatusText));
                licenseStatusString = br.readLine();
                divPos = licenseStatusString.indexOf(58);
                if (divPos != -1) break block5;
                return false;
            }
            catch (Exception e) {
                log.log(Level.WARNING, "License status check error", e);
                return false;
            }
        }
        String statusCode = licenseStatusString.substring(0, divPos).trim();
        try {
            return LMLicenseStatus.VALID.equals((Object)LMLicenseStatus.valueOf(statusCode));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
    }

    public static boolean isEmail(@NotNull String email) {
        String emailPattern = "^\\S+@\\S+\\.\\S+$";
        Pattern p = Pattern.compile(emailPattern);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    @NotNull
    public static String getCompareString(@NotNull String cmpString) {
        switch (cmpString) {
            case "<": 
            case "=": 
            case ">": 
            case "<=": 
            case "<>": 
            case ">=": {
                break;
            }
            default: {
                cmpString = "=";
            }
        }
        return cmpString;
    }
}

