/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.ui;

import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudUtils;
import com.dbeaver.cloud.aws.AWSSecretManagerConfiguration;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.regions.Region;

public class PrefPageAwsSecretManager
extends AbstractPrefPage {
    private static final Log log = Log.getLog(PrefPageAwsSecretManager.class);
    private AWSCloudConfiguration cloudConfiguration;
    private Combo secretsRegionText;
    private Text encryptionKeyText;
    private Text secretPolicyText;
    private Text privateSecretPrefixText;
    private Text roleSecretPrefixText;

    @NotNull
    private AWSCloudConfiguration getCloudConfiguration() {
        return this.cloudConfiguration;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite saGroup = new Composite(parent, 0);
        saGroup.setLayout((Layout)new GridLayout(2, false));
        Group smGroup = UIUtils.createControlGroup((Composite)saGroup, (String)"AWS Secret Manager", (int)2, (int)1808, (int)-1);
        this.secretsRegionText = UIUtils.createLabelCombo((Composite)smGroup, (String)"Secrets region", (int)2052);
        for (Region region : AWSCloudUtils.getAllRegions((AWSCloudConfiguration)this.getCloudConfiguration())) {
            this.secretsRegionText.add(region.toString());
        }
        this.encryptionKeyText = UIUtils.createLabelText((Composite)smGroup, (String)"Encryption key", null);
        this.secretPolicyText = UIUtils.createLabelText((Composite)smGroup, (String)"Secret policy", null, (int)2562);
        GridData gd = new GridData(1808);
        gd.heightHint = UIUtils.getFontHeight((Control)this.secretPolicyText) * 7;
        this.secretPolicyText.setLayoutData((Object)gd);
        this.privateSecretPrefixText = UIUtils.createLabelText((Composite)smGroup, (String)"Private secret prefix", null);
        this.roleSecretPrefixText = UIUtils.createLabelText((Composite)smGroup, (String)"Role secret prefix", null);
        UIUtils.createInfoLabel((Composite)smGroup, (String)"You can use this configuration if AWS Secrets Manager was set as default secret controller in the server configuration.", (int)768, (int)2);
        return saGroup;
    }

    public void loadSettings(CPCloudConfiguration<?> cloudConfiguration) {
        this.cloudConfiguration = (AWSCloudConfiguration)cloudConfiguration;
        AWSSecretManagerConfiguration smConfig = this.cloudConfiguration.getSecretManagerConfiguration();
        if (smConfig == null) {
            smConfig = AWSSecretManagerConfiguration.DEFAULT_CONFIGURATION;
        }
        this.secretsRegionText.setText(smConfig.getPrimaryRegion());
        this.encryptionKeyText.setText(CommonUtils.notEmpty((String)smConfig.getEncryptionKey()));
        this.secretPolicyText.setText(CommonUtils.notEmpty((String)smConfig.getResourcePolicy()));
        this.privateSecretPrefixText.setText(CommonUtils.notEmpty((String)smConfig.getPrivateSecretPrefix()));
        this.roleSecretPrefixText.setText(CommonUtils.notEmpty((String)smConfig.getRoleSecretPrefix()));
    }

    protected void performApply() {
        super.performApply();
        if (this.cloudConfiguration == null || this.secretsRegionText == null) {
            return;
        }
        AWSSecretManagerConfiguration smConfig = this.cloudConfiguration.getSecretManagerConfiguration();
        if (smConfig == null) {
            smConfig = new AWSSecretManagerConfiguration();
            this.cloudConfiguration.setSecretManagerConfiguration(smConfig);
        }
        smConfig.setPrimaryRegion(this.secretsRegionText.getText());
        smConfig.setEncryptionKey(this.encryptionKeyText.getText());
        smConfig.setResourcePolicy(this.secretPolicyText.getText());
        smConfig.setPrivateSecretPrefix(this.privateSecretPrefixText.getText());
        smConfig.setRoleSecretPrefix(this.roleSecretPrefixText.getText());
    }
}

