/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2.model;

import com.dbeaver.ee.influxdb2.FluxUtils;
import com.dbeaver.ee.influxdb2.exec.Influx2ExecutionContext;
import com.dbeaver.ee.influxdb2.exec.Influx2ResultSet;
import com.dbeaver.ee.influxdb2.exec.Influx2SelectStatement;
import com.dbeaver.ee.influxdb2.exec.Influx2Session;
import com.dbeaver.ee.influxdb2.model.Influx2DataSource;
import com.dbeaver.ee.influxdb2.model.Influx2DataType;
import com.dbeaver.ee.influxdb2.model.Influx2Database;
import com.dbeaver.ee.influxdb2.model.Influx2MeasurementField;
import com.dbeaver.ee.influxdb2.model.Influx2MeasurementTag;
import com.influxdb.client.InfluxDBClient;
import com.influxdb.query.FluxRecord;
import com.influxdb.query.FluxTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.utils.CommonUtils;

public class Influx2Measurement
implements DBSEntity,
DBSDataContainer,
DBSDataManipulator,
DBPRefreshableObject {
    private static final Log log = Log.getLog(Influx2Measurement.class);
    private final Influx2Database database;
    private final String name;
    private final FieldCache fieldCache = new FieldCache();
    private final TagCache tagCache = new TagCache();
    private transient MeasurementKey measurementKey;
    public static final DBSEntityConstraintType TIME_KEY = new DBSEntityConstraintType("time", "TIME KEY", "Time Key", false, true, false, false);

    protected Influx2Measurement(Influx2Database database, String name) {
        this.database = database;
        this.name = name;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public Influx2Database getDatabase() {
        return this.database;
    }

    public String getDescription() {
        return null;
    }

    @NotNull
    public Influx2Database getParentObject() {
        return this.database;
    }

    @NotNull
    public Influx2DataSource getDataSource() {
        return this.database.getDataSource();
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    @Association
    public List<Influx2MeasurementField> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getFields(monitor);
    }

    @Association
    public List<Influx2MeasurementField> getFields(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.fieldCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<Influx2MeasurementTag> getTags(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.tagCache.getAllObjects(monitor, this);
    }

    public Influx2MeasurementField getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return this.fieldCache.getObject(monitor, this, attributeName);
    }

    public Collection<? extends DBSEntityConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.measurementKey == null) {
            this.measurementKey = new MeasurementKey();
        }
        return Collections.singletonList(this.measurementKey);
    }

    public Collection<? extends DBSTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String[] getSupportedFeatures() {
        return new String[]{"data.count", "data.filter", "data.insert", "data.update", "data.delete"};
    }

    @NotNull
    public DBCStatistics readData(@Nullable DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        try {
            DBCStatistics statistics;
            block21: {
                Influx2Session influxSession = (Influx2Session)session;
                statistics = new DBCStatistics();
                StringBuilder query = new StringBuilder();
                query.append("from(bucket: ").append("\"").append(this.getParentObject()).append("\")");
                query.append("\n|> range(start: 0)");
                query.append("\n|> filter(fn: (r) => r._measurement == ").append("\"").append(this.getName()).append("\")");
                SQLUtils.appendQueryConditions((DBPDataSource)this.getDataSource(), (StringBuilder)query, null, (DBDDataFilter)dataFilter);
                if (maxRows != -1L) {
                    FluxUtils.appendLimitInfo(query, maxRows);
                }
                query.append("\n|> group()");
                SQLUtils.appendQueryOrder((DBPDataSource)this.getDataSource(), (StringBuilder)query, null, (DBDDataFilter)dataFilter);
                Throwable throwable = null;
                Object var16_15 = null;
                try (Influx2SelectStatement statement = new Influx2SelectStatement(influxSession, this.getDatabase(), query.toString());){
                    statement.setStatementSource(source);
                    statement.setLimit(firstRow, maxRows);
                    statistics.setQueryText(statement.getQueryString());
                    statistics.addStatementsCount();
                    if (!statement.executeStatement()) break block21;
                    Throwable throwable2 = null;
                    Object var19_20 = null;
                    try (Influx2ResultSet resultSet = statement.openResultSet();){
                        DBDDataReceiver.startFetchWorkflow((DBDDataReceiver)dataReceiver, (DBCSession)influxSession, (DBCResultSet)resultSet, (long)firstRow, (long)maxRows);
                        DBDDataReceiver.fetchRowsWithStatistics((DBDDataReceiver)dataReceiver, (DBCSession)session, (DBCResultSet)resultSet, (DBCStatistics)statistics);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            return statistics;
        }
        catch (Throwable e) {
            throw new DBCException(e, session.getExecutionContext());
        }
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        List influxQLQueryResult;
        block3: {
            try {
                StringBuilder query = new StringBuilder();
                query.append("from(bucket: ").append("\"").append(this.getParentObject()).append("\")");
                query.append("\n|> range(start: 0)");
                query.append("\n|> filter(fn: (r) => r._measurement == ").append("\"").append(this.getName()).append("\")");
                SQLUtils.appendQueryConditions((DBPDataSource)this.getDataSource(), (StringBuilder)query, null, (DBDDataFilter)dataFilter);
                query.append("\n|> count()");
                Influx2Session influxSession = (Influx2Session)session;
                InfluxDBClient influxDB = influxSession.getClient();
                influxQLQueryResult = influxDB.getQueryApi().query(query.toString());
                if (!CommonUtils.isEmpty((Collection)influxQLQueryResult)) break block3;
                return -1L;
            }
            catch (Throwable e) {
                throw new DBCException(e, session.getExecutionContext());
            }
        }
        return CommonUtils.toLong(((FluxTable)influxQLQueryResult.get(0)).getRecords().get(0), (long)-1L);
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch insertData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, @NotNull DBCExecutionSource source, @NotNull Map<String, Object> options) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch updateData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] updateAttributes, @NotNull DBSAttributeBase[] keyAttributes, @Nullable DBDDataReceiver keysReceiver, @NotNull DBCExecutionSource source) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch deleteData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] keyAttributes, @NotNull DBCExecutionSource source) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    @NotNull
    public DBCStatistics truncateData(@NotNull DBCSession session, @NotNull DBCExecutionSource source) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    private String getAttributeName(DBSAttributeBase attribute) {
        return DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)attribute.getName());
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.fieldCache.clearCache();
        this.tagCache.clearCache();
        return this;
    }

    class FieldCache
    extends AbstractObjectCache<Influx2Measurement, Influx2MeasurementField> {
        FieldCache() {
        }

        @NotNull
        public List<Influx2MeasurementField> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable Influx2Measurement measurement) throws DBException {
            if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
                Influx2DataSource dataSource = measurement.getDataSource();
                ArrayList<Influx2MeasurementField> fields = new ArrayList<Influx2MeasurementField>();
                InfluxDBClient influxDB = ((Influx2ExecutionContext)Influx2Measurement.this.getDataSource().getDefaultContext(monitor, true)).getClient();
                List dbListResult = influxDB.getQueryApi().query("import \"influxdata/influxdb/schema\" schema.measurementFieldKeys(bucket: \"" + Influx2Measurement.this.getDatabase().getName() + "\",measurement: \"" + Influx2Measurement.this.getName() + "\", start: 0)");
                for (FluxTable result : dbListResult) {
                    for (FluxRecord dbObj : CommonUtils.safeList((List)result.getRecords())) {
                        Influx2DataType dataType;
                        Object fieldName = dbObj.getValue();
                        String fieldType = dbObj.getField();
                        if (fieldType == null) {
                            dataType = dataSource.getLocalDataType(Influx2DataType.TypeName.FLOAT.getTypeName());
                        } else {
                            dataType = dataSource.getLocalDataType(CommonUtils.toString((Object)fieldType));
                            if (dataType == null) {
                                log.error((Object)("Can't find data type '" + String.valueOf(fieldType) + "' for field '" + String.valueOf(fieldName) + "'"));
                                dataType = dataSource.getLocalDataType(Influx2DataType.TypeName.UNKNOWN.getTypeName());
                            }
                        }
                        Influx2MeasurementField field = new Influx2MeasurementField(measurement, fields.size(), CommonUtils.toString((Object)fieldName), dataType);
                        fields.add(field);
                    }
                }
                fields.sort(DBUtils.nameComparator());
                this.setCache(fields);
            }
            return this.getCachedObjects();
        }

        public Influx2MeasurementField getObject(@NotNull DBRProgressMonitor monitor, @NotNull Influx2Measurement measurement, @NotNull String name) throws DBException {
            return (Influx2MeasurementField)DBUtils.findObject(this.getAllObjects(monitor, measurement), (String)name);
        }
    }

    public class MeasurementKey
    implements DBSEntityConstraint,
    DBSEntityReferrer {
        @Property(viewable=true, editable=true, order=1)
        @NotNull
        public String getName() {
            return "time_key";
        }

        @Property(viewable=true, editable=true, order=2)
        @NotNull
        public DBSEntityConstraintType getConstraintType() {
            return TIME_KEY;
        }

        @NotNull
        public Influx2Measurement getParentObject() {
            return Influx2Measurement.this;
        }

        public String getDescription() {
            return null;
        }

        @NotNull
        public DBPDataSource getDataSource() {
            return Influx2Measurement.this.getDataSource();
        }

        public boolean isPersisted() {
            return true;
        }

        public List<FieldColumn> getAttributeReferences(@Nullable DBRProgressMonitor monitor) throws DBException {
            Influx2MeasurementField timeField = Influx2Measurement.this.fieldCache.getObject(monitor, Influx2Measurement.this, "_time");
            return timeField == null ? Collections.emptyList() : Collections.singletonList(new FieldColumn(timeField));
        }

        public class FieldColumn
        implements DBSObject,
        DBSEntityAttributeRef {
            private final Influx2MeasurementField timeField;

            public FieldColumn(Influx2MeasurementField timeField) {
                this.timeField = timeField;
            }

            @NotNull
            public DBSEntityAttribute getAttribute() {
                return this.timeField;
            }

            public DBSObject getParentObject() {
                return MeasurementKey.this;
            }

            @NotNull
            public DBPDataSource getDataSource() {
                return MeasurementKey.this.getDataSource();
            }

            @Property(viewable=true, editable=true, order=1)
            @NotNull
            public String getName() {
                return this.timeField.getName();
            }

            public boolean isPersisted() {
                return true;
            }

            public String getDescription() {
                return null;
            }
        }
    }

    class TagCache
    extends AbstractObjectCache<Influx2Measurement, Influx2MeasurementTag> {
        TagCache() {
        }

        @NotNull
        public Collection<Influx2MeasurementTag> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable Influx2Measurement measurement) throws DBException {
            if (!this.isFullyCached()) {
                measurement.getDataSource();
                ArrayList<Influx2MeasurementTag> fields = new ArrayList<Influx2MeasurementTag>();
                InfluxDBClient influxDB = ((Influx2ExecutionContext)Influx2Measurement.this.getDataSource().getDefaultContext(monitor, true)).getClient();
                List dbListResult = influxDB.getQueryApi().query("import \"influxdata/influxdb/schema\" schema.measurementTagKeys(bucket: \"" + Influx2Measurement.this.getDatabase().getName() + "\", measurement: \"" + Influx2Measurement.this.getName() + "\", start: 0)");
                for (FluxTable result : dbListResult) {
                    for (FluxRecord dbObj : CommonUtils.safeList((List)result.getRecords())) {
                        Object fieldName = dbObj.getValue();
                        Influx2MeasurementTag tag = new Influx2MeasurementTag(measurement, fields.size(), CommonUtils.toString((Object)fieldName));
                        fields.add(tag);
                    }
                }
                fields.sort(DBUtils.nameComparator());
                this.setCache(fields);
            }
            return this.getCachedObjects();
        }

        public Influx2MeasurementTag getObject(@NotNull DBRProgressMonitor monitor, @NotNull Influx2Measurement influxDatabase, @NotNull String name) throws DBException {
            return (Influx2MeasurementTag)DBUtils.findObject(this.getAllObjects(monitor, influxDatabase), (String)name);
        }
    }
}

