/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2.exec;

import com.dbeaver.ee.influxdb2.Influx2Utils;
import com.dbeaver.ee.influxdb2.exec.Influx2BaseStatement;
import com.dbeaver.ee.influxdb2.exec.Influx2ResultSetMetaColumn;
import com.dbeaver.ee.influxdb2.exec.Influx2Session;
import com.influxdb.query.FluxColumn;
import com.influxdb.query.FluxRecord;
import com.influxdb.query.FluxTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractResultSet;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetMeta;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class Influx2ResultSet
extends AbstractResultSet<Influx2Session, Influx2BaseStatement>
implements DBRBlockingObject {
    private FluxTable series;
    private DBCResultSetMetaData metaData;
    private FluxRecord curRow;
    private int rowCount = 0;

    public Influx2ResultSet(Influx2BaseStatement statement, FluxTable series) {
        super((DBCSession)((Influx2Session)statement.getSession()), (DBCStatement)statement);
        this.series = series;
        if (((Influx2Session)statement.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
        ((Influx2Session)statement.getSession()).getProgressMonitor().startBlock((DBRBlockingObject)this, "Fetch result");
    }

    public String getTableName() {
        return ((FluxRecord)this.series.getRecords().get(0)).getMeasurement();
    }

    public FluxTable getTable() {
        return this.series;
    }

    @NotNull
    public Influx2Session getSession() {
        return (Influx2Session)((Influx2BaseStatement)this.statement).getSession();
    }

    @NotNull
    public Influx2BaseStatement getSourceStatement() {
        return (Influx2BaseStatement)this.statement;
    }

    private void checkRowFetched() throws DBCException {
        if (this.curRow == null) {
            throw new DBCException("Row not fetched");
        }
    }

    public Object getAttributeValue(int index) throws DBCException {
        this.checkRowFetched();
        return this.curRow.getValueByIndex(index);
    }

    public Object getAttributeValue(String name) throws DBCException {
        this.checkRowFetched();
        return null;
    }

    public FluxRecord getCurRow() {
        return this.curRow;
    }

    public boolean nextRow() throws DBCException {
        if (this.series == null) {
            return false;
        }
        List values = this.series.getRecords();
        if (CommonUtils.isEmpty((Collection)values) || values.size() <= this.rowCount) {
            return false;
        }
        this.curRow = (FluxRecord)values.get(this.rowCount);
        ++this.rowCount;
        return true;
    }

    public boolean moveTo(int position) throws DBCException {
        this.rowCount = position;
        return true;
    }

    @NotNull
    public DBCResultSetMetaData getMeta() throws DBCException {
        if (this.metaData == null) {
            ArrayList<Influx2ResultSetMetaColumn> attrs = new ArrayList<Influx2ResultSetMetaColumn>();
            if (this.series != null) {
                for (FluxColumn col : this.series.getColumns()) {
                    attrs.add(new Influx2ResultSetMetaColumn(this, attrs.size(), col.getLabel(), Influx2Utils.getDataType(col.getDataType())));
                }
            }
            this.metaData = new LocalResultSetMeta(attrs);
        }
        return this.metaData;
    }

    public String getResultSetName() throws DBCException {
        if (this.series == null) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        if (!CommonUtils.isEmpty((Collection)this.series.getRecords())) {
            name.append(((FluxRecord)this.series.getRecords().get(0)).getMeasurement());
        }
        return name.toString();
    }

    public Object getFeature(String name) {
        if ("timeseries".equals(name)) {
            return true;
        }
        return super.getFeature(name);
    }

    public void close() {
        ((Influx2Session)((Influx2BaseStatement)this.statement).getSession()).getProgressMonitor().endBlock();
        if (((Influx2Session)((Influx2BaseStatement)this.statement).getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetClose((DBCResultSet)this, (long)this.rowCount);
        }
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
    }
}

