/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.anthropic.dto;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionDescriptor;

public record AnthropicTool(String name, String description, @SerializedName(value="input_schema") InputSchema inputSchema) {
    public static final String TYPE_OBJECT = "object";

    public AnthropicTool(@NotNull AIFunctionDescriptor function) {
        this(function.getId(), function.getDescription(), new InputSchema(AnthropicTool.createInputSchemaProperties(function), (String[])Arrays.stream(function.getParameters()).filter(AIFunctionDescriptor.Parameter::isRequired).map(AIFunctionDescriptor.Parameter::getName).toArray(String[]::new), TYPE_OBJECT));
    }

    @NotNull
    private static Map<String, InputSchema.Parameter> createInputSchemaProperties(@NotNull AIFunctionDescriptor function) {
        LinkedHashMap<String, InputSchema.Parameter> inputSchemaProperties = new LinkedHashMap<String, InputSchema.Parameter>();
        AIFunctionDescriptor.Parameter[] parameterArray = function.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            AIFunctionDescriptor.Parameter param = parameterArray[n2];
            InputSchema.Parameter parameter = new InputSchema.Parameter(param.getType(), param.getDescription(), param.getValidValues());
            inputSchemaProperties.put(param.getName(), parameter);
            ++n2;
        }
        return inputSchemaProperties;
    }

    public record InputSchema(Map<String, Parameter> properties, String[] required, String type) {

        public record Parameter(String type, String description, @SerializedName(value="enum") String[] enumValues) {
        }
    }
}

