/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.audio.processing;

import com.dbeaver.model.ai.audio.AIAudioRecorder;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import org.jkiss.code.NotNull;

public class AudioDurationMonitor
implements Flow.Subscriber<ByteBuffer> {
    private final Runnable onThresholdReached;
    private final int bytesPerFrame;
    private final AtomicBoolean fired = new AtomicBoolean(false);
    private final long thresholdFrames;
    private Flow.Subscription subscription;
    private long processedFrames;

    public AudioDurationMonitor(@NotNull AudioFormat format, long thresholdMillis, @NotNull Runnable onThresholdReached) {
        this.onThresholdReached = onThresholdReached;
        this.bytesPerFrame = Math.max(1, format.getFrameSize());
        this.thresholdFrames = Math.round((double)thresholdMillis / 1000.0 * (double)format.getFrameRate());
    }

    @Override
    public void onSubscribe(@NotNull Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(@NotNull ByteBuffer item) {
        try {
            if (item == AIAudioRecorder.RESET_SIGNAL) {
                this.reset();
            } else {
                this.processedFrames += (long)this.framesIn(item);
                this.checkThreshold();
            }
        }
        finally {
            this.subscription.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onError(@NotNull Throwable throwable) {
    }

    @Override
    public void onComplete() {
    }

    public void reset() {
        this.processedFrames = 0L;
        this.fired.set(false);
    }

    private int framesIn(@NotNull ByteBuffer buf) {
        return buf.remaining() / this.bytesPerFrame;
    }

    private void checkThreshold() {
        if (this.processedFrames >= this.thresholdFrames && this.fired.compareAndSet(false, true)) {
            this.onThresholdReached.run();
        }
    }
}

