/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.subscription.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.subscription.models.Workload;
import java.io.IOException;

public final class PutAliasRequestProperties
implements JsonSerializable<PutAliasRequestProperties> {
    private String displayName;
    private Workload workload;
    private String billingScope;
    private String subscriptionId;
    private String resellerId;

    public String displayName() {
        return this.displayName;
    }

    public PutAliasRequestProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Workload workload() {
        return this.workload;
    }

    public PutAliasRequestProperties withWorkload(Workload workload) {
        this.workload = workload;
        return this;
    }

    public String billingScope() {
        return this.billingScope;
    }

    public PutAliasRequestProperties withBillingScope(String billingScope) {
        this.billingScope = billingScope;
        return this;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public PutAliasRequestProperties withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String resellerId() {
        return this.resellerId;
    }

    public PutAliasRequestProperties withResellerId(String resellerId) {
        this.resellerId = resellerId;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("workload", this.workload == null ? null : this.workload.toString());
        jsonWriter.writeStringField("billingScope", this.billingScope);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("resellerId", this.resellerId);
        return jsonWriter.writeEndObject();
    }

    public static PutAliasRequestProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PutAliasRequestProperties)jsonReader.readObject(reader -> {
            PutAliasRequestProperties deserializedPutAliasRequestProperties = new PutAliasRequestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedPutAliasRequestProperties.displayName = reader.getString();
                    continue;
                }
                if ("workload".equals(fieldName)) {
                    deserializedPutAliasRequestProperties.workload = Workload.fromString(reader.getString());
                    continue;
                }
                if ("billingScope".equals(fieldName)) {
                    deserializedPutAliasRequestProperties.billingScope = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedPutAliasRequestProperties.subscriptionId = reader.getString();
                    continue;
                }
                if ("resellerId".equals(fieldName)) {
                    deserializedPutAliasRequestProperties.resellerId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPutAliasRequestProperties;
        });
    }
}

