/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.subscription.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.subscription.SubscriptionManager;
import com.azure.resourcemanager.subscription.fluent.SubscriptionOperationsClient;
import com.azure.resourcemanager.subscription.fluent.models.CanceledSubscriptionIdInner;
import com.azure.resourcemanager.subscription.fluent.models.EnabledSubscriptionIdInner;
import com.azure.resourcemanager.subscription.fluent.models.RenamedSubscriptionIdInner;
import com.azure.resourcemanager.subscription.implementation.CanceledSubscriptionIdImpl;
import com.azure.resourcemanager.subscription.implementation.EnabledSubscriptionIdImpl;
import com.azure.resourcemanager.subscription.implementation.RenamedSubscriptionIdImpl;
import com.azure.resourcemanager.subscription.models.CanceledSubscriptionId;
import com.azure.resourcemanager.subscription.models.EnabledSubscriptionId;
import com.azure.resourcemanager.subscription.models.RenamedSubscriptionId;
import com.azure.resourcemanager.subscription.models.SubscriptionName;
import com.azure.resourcemanager.subscription.models.SubscriptionOperations;

public final class SubscriptionOperationsImpl
implements SubscriptionOperations {
    private static final ClientLogger LOGGER = new ClientLogger(SubscriptionOperationsImpl.class);
    private final SubscriptionOperationsClient innerClient;
    private final SubscriptionManager serviceManager;

    public SubscriptionOperationsImpl(SubscriptionOperationsClient innerClient, SubscriptionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CanceledSubscriptionId> cancelWithResponse(String subscriptionId, Context context) {
        Response<CanceledSubscriptionIdInner> inner = this.serviceClient().cancelWithResponse(subscriptionId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CanceledSubscriptionIdImpl((CanceledSubscriptionIdInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CanceledSubscriptionId cancel(String subscriptionId) {
        CanceledSubscriptionIdInner inner = this.serviceClient().cancel(subscriptionId);
        if (inner != null) {
            return new CanceledSubscriptionIdImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<RenamedSubscriptionId> renameWithResponse(String subscriptionId, SubscriptionName body, Context context) {
        Response<RenamedSubscriptionIdInner> inner = this.serviceClient().renameWithResponse(subscriptionId, body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RenamedSubscriptionIdImpl((RenamedSubscriptionIdInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public RenamedSubscriptionId rename(String subscriptionId, SubscriptionName body) {
        RenamedSubscriptionIdInner inner = this.serviceClient().rename(subscriptionId, body);
        if (inner != null) {
            return new RenamedSubscriptionIdImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<EnabledSubscriptionId> enableWithResponse(String subscriptionId, Context context) {
        Response<EnabledSubscriptionIdInner> inner = this.serviceClient().enableWithResponse(subscriptionId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new EnabledSubscriptionIdImpl((EnabledSubscriptionIdInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public EnabledSubscriptionId enable(String subscriptionId) {
        EnabledSubscriptionIdInner inner = this.serviceClient().enable(subscriptionId);
        if (inner != null) {
            return new EnabledSubscriptionIdImpl(inner, this.manager());
        }
        return null;
    }

    private SubscriptionOperationsClient serviceClient() {
        return this.innerClient;
    }

    private SubscriptionManager manager() {
        return this.serviceManager;
    }
}

