/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.yellowbrick.ui;

import com.dbeaver.db.yellowbrick.YellowbrickOAuthModel;
import com.dbeaver.db.yellowbrick.ui.YellowbrickUIMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class YellowbrickOAuthConfigurator
implements IObjectPropertyConfigurator<YellowbrickOAuthModel, DBPDataSourceContainer> {
    private Text clientIDText;
    private Text clientSecretText;
    private Text issuerText;

    public void createControl(@NotNull Composite authPanel, YellowbrickOAuthModel object, @NotNull Runnable propertyChangeListener) {
        this.issuerText = UIUtils.createLabelText((Composite)authPanel, (String)YellowbrickUIMessages.auth_configurator_issuer_label, (String)"", (int)2048);
        this.issuerText.setMessage(YellowbrickUIMessages.auth_configurator_issuer_message);
        this.issuerText.setToolTipText(YellowbrickUIMessages.auth_configurator_issuer_tip);
        this.issuerText.addModifyListener(e -> propertyChangeListener.run());
        this.clientIDText = UIUtils.createLabelText((Composite)authPanel, (String)YellowbrickUIMessages.auth_configurator_client_id, (String)"", (int)0x400800);
        this.clientIDText.setMessage(YellowbrickUIMessages.auth_configurator_client_id_message);
        this.clientIDText.setToolTipText(YellowbrickUIMessages.auth_configurator_client_id_tip);
        this.clientIDText.addModifyListener(e -> propertyChangeListener.run());
        this.clientSecretText = UIUtils.createLabelText((Composite)authPanel, (String)YellowbrickUIMessages.auth_configurator_client_secret, (String)"", (int)0x400800);
        this.clientSecretText.setMessage(YellowbrickUIMessages.auth_configurator_client_secret_message);
        this.clientSecretText.setToolTipText(YellowbrickUIMessages.auth_configurator_client_secret_tip);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPConnectionConfiguration connectionInfo = dataSourceContainer.getConnectionConfiguration();
        if (this.issuerText != null && !this.issuerText.isDisposed()) {
            this.issuerText.setText(CommonUtils.notEmpty((String)connectionInfo.getAuthProperty("oauth2Issuer")));
        }
        if (this.clientIDText != null && !this.clientIDText.isDisposed()) {
            this.clientIDText.setText(CommonUtils.notEmpty((String)connectionInfo.getAuthProperty("oauth2ClientId")));
        }
        if (this.clientSecretText != null && !this.clientSecretText.isDisposed()) {
            this.clientSecretText.setText(CommonUtils.notEmpty((String)connectionInfo.getAuthProperty("oauth2ClientSecret")));
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPConnectionConfiguration connectionInfo = dataSourceContainer.getConnectionConfiguration();
        if (this.issuerText != null && !this.issuerText.isDisposed()) {
            connectionInfo.setAuthProperty("oauth2Issuer", this.issuerText.getText().trim());
        }
        if (this.clientIDText != null && !this.clientIDText.isDisposed()) {
            connectionInfo.setAuthProperty("oauth2ClientId", this.clientIDText.getText().trim());
        }
        if (this.clientSecretText != null && !this.clientSecretText.isDisposed()) {
            connectionInfo.setAuthProperty("oauth2ClientSecret", this.clientSecretText.getText().trim());
        }
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        this.loadSettings(dataSourceContainer);
    }

    public boolean isComplete() {
        return !this.clientIDText.getText().isEmpty() && !this.issuerText.getText().isEmpty();
    }
}

