/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.model;

import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.impl.struct.AbstractDataType;

public class DynamoDataType
extends AbstractDataType<DynamoDataSource> {
    private static final Log log = Log.getLog(DynamoDataType.class);
    private final TypeName typeName;

    public DynamoDataType(DynamoDataSource dataSource, TypeName typeName) {
        super((DBPDataSource)dataSource);
        this.typeName = typeName;
    }

    @NotNull
    public String getTypeName() {
        return this.typeName.typeName;
    }

    public int getTypeID() {
        return this.typeName.typeId;
    }

    @NotNull
    public DBPDataKind getDataKind() {
        return this.typeName.dataKind;
    }

    public static enum TypeName {
        FLOAT("float", 6, DBPDataKind.NUMERIC),
        INTEGER("integer", 5, DBPDataKind.NUMERIC),
        STRING("string", 3, DBPDataKind.STRING),
        BOOLEAN("boolean", 7, DBPDataKind.BOOLEAN),
        TIMESTAMP("timestamp", 8, DBPDataKind.DATETIME),
        UNKNOWN("unknown", 11, DBPDataKind.OBJECT);

        private final String typeName;
        private final int typeId;
        private final DBPDataKind dataKind;

        private TypeName(String typeName, int typeId, DBPDataKind dataKind) {
            this.typeName = typeName;
            this.typeId = typeId;
            this.dataKind = dataKind;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getTypeId() {
            return this.typeId;
        }

        public DBPDataKind getDataKind() {
            return this.dataKind;
        }
    }
}

