/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.dbeaver.model.document.exec.DocumentReadStatement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public abstract class DynamoBaseStatement
extends DocumentReadStatement<DynamoSession> {
    protected long offset;
    protected long limit;

    protected DynamoBaseStatement(DynamoSession session, DBCExecutionSource source) {
        super((DBCSession)session);
        this.setStatementSource(source);
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    protected DynamoBaseStatement(DynamoSession session) {
        this(session, null);
    }

    public abstract DynamoTable getSourceEntity();

    public long getUpdateRowCount() {
        return -1L;
    }

    public boolean nextResults() throws DBCException {
        return false;
    }

    public void setLimit(long offset, long limit) {
        this.offset = offset;
        this.limit = limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread == null) {
            throw new DBException("DynamoDB query cancel not implemented");
        }
        blockThread.interrupt();
    }

    @Nullable
    public DBCResultSet openResultSet() throws DBCException {
        return null;
    }

    @NotNull
    protected DynamoTable getDynamoTable(@NotNull String tableName) throws DBCException {
        try {
            DynamoTable table = ((DynamoSession)this.getSession()).getDataSource().getTable(((DynamoSession)this.getSession()).getProgressMonitor(), DBUtils.getUnQuotedIdentifier((DBPDataSource)((DynamoSession)this.getSession()).getDataSource(), (String)tableName));
            if (table == null) {
                throw new DBCException("DynamoDB table '" + tableName + "' not found");
            }
            return table;
        }
        catch (DBException ex) {
            throw new DBCException(ex.getMessage());
        }
    }
}

