/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.Association;
import software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse;

public class ListCustomDomainAssociationsIterable
implements SdkIterable<ListCustomDomainAssociationsResponse> {
    private final RedshiftServerlessClient client;
    private final ListCustomDomainAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomDomainAssociationsIterable(RedshiftServerlessClient client, ListCustomDomainAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCustomDomainAssociationsResponseFetcher();
    }

    public Iterator<ListCustomDomainAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Association> associations() {
        Function<ListCustomDomainAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associations() != null) {
                return response.associations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCustomDomainAssociationsResponseFetcher
    implements SyncPageFetcher<ListCustomDomainAssociationsResponse> {
        private ListCustomDomainAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomDomainAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomDomainAssociationsResponse nextPage(ListCustomDomainAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomDomainAssociationsIterable.this.client.listCustomDomainAssociations(ListCustomDomainAssociationsIterable.this.firstRequest);
            }
            return ListCustomDomainAssociationsIterable.this.client.listCustomDomainAssociations((ListCustomDomainAssociationsRequest)((Object)ListCustomDomainAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

