/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessResponse;
import software.amazon.awssdk.services.redshiftserverless.model.SnapshotCopyConfiguration;
import software.amazon.awssdk.services.redshiftserverless.model.SnapshotCopyConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSnapshotCopyConfigurationsResponse
extends RedshiftServerlessResponse
implements ToCopyableBuilder<Builder, ListSnapshotCopyConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSnapshotCopyConfigurationsResponse.getter(ListSnapshotCopyConfigurationsResponse::nextToken)).setter(ListSnapshotCopyConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SnapshotCopyConfiguration>> SNAPSHOT_COPY_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("snapshotCopyConfigurations").getter(ListSnapshotCopyConfigurationsResponse.getter(ListSnapshotCopyConfigurationsResponse::snapshotCopyConfigurations)).setter(ListSnapshotCopyConfigurationsResponse.setter(Builder::snapshotCopyConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotCopyConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotCopyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SNAPSHOT_COPY_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSnapshotCopyConfigurationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<SnapshotCopyConfiguration> snapshotCopyConfigurations;

    private ListSnapshotCopyConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.snapshotCopyConfigurations = builder.snapshotCopyConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSnapshotCopyConfigurations() {
        return this.snapshotCopyConfigurations != null && !(this.snapshotCopyConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SnapshotCopyConfiguration> snapshotCopyConfigurations() {
        return this.snapshotCopyConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshotCopyConfigurations() ? this.snapshotCopyConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSnapshotCopyConfigurationsResponse)) {
            return false;
        }
        ListSnapshotCopyConfigurationsResponse other = (ListSnapshotCopyConfigurationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSnapshotCopyConfigurations() == other.hasSnapshotCopyConfigurations() && Objects.equals(this.snapshotCopyConfigurations(), other.snapshotCopyConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ListSnapshotCopyConfigurationsResponse").add("NextToken", (Object)this.nextToken()).add("SnapshotCopyConfigurations", this.hasSnapshotCopyConfigurations() ? this.snapshotCopyConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "snapshotCopyConfigurations": {
                return Optional.ofNullable(clazz.cast(this.snapshotCopyConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("snapshotCopyConfigurations", SNAPSHOT_COPY_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSnapshotCopyConfigurationsResponse, T> g) {
        return obj -> g.apply((ListSnapshotCopyConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SnapshotCopyConfiguration> snapshotCopyConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSnapshotCopyConfigurationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.snapshotCopyConfigurations(model.snapshotCopyConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SnapshotCopyConfiguration.Builder> getSnapshotCopyConfigurations() {
            List<SnapshotCopyConfiguration.Builder> result = SnapshotCopyConfigurationsCopier.copyToBuilder(this.snapshotCopyConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshotCopyConfigurations(Collection<SnapshotCopyConfiguration.BuilderImpl> snapshotCopyConfigurations) {
            this.snapshotCopyConfigurations = SnapshotCopyConfigurationsCopier.copyFromBuilder(snapshotCopyConfigurations);
        }

        @Override
        public final Builder snapshotCopyConfigurations(Collection<SnapshotCopyConfiguration> snapshotCopyConfigurations) {
            this.snapshotCopyConfigurations = SnapshotCopyConfigurationsCopier.copy(snapshotCopyConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotCopyConfigurations(SnapshotCopyConfiguration ... snapshotCopyConfigurations) {
            this.snapshotCopyConfigurations(Arrays.asList(snapshotCopyConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotCopyConfigurations(Consumer<SnapshotCopyConfiguration.Builder> ... snapshotCopyConfigurations) {
            this.snapshotCopyConfigurations(Stream.of(snapshotCopyConfigurations).map(c -> (SnapshotCopyConfiguration)((SnapshotCopyConfiguration.Builder)SnapshotCopyConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSnapshotCopyConfigurationsResponse build() {
            return new ListSnapshotCopyConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSnapshotCopyConfigurationsResponse> {
        public Builder nextToken(String var1);

        public Builder snapshotCopyConfigurations(Collection<SnapshotCopyConfiguration> var1);

        public Builder snapshotCopyConfigurations(SnapshotCopyConfiguration ... var1);

        public Builder snapshotCopyConfigurations(Consumer<SnapshotCopyConfiguration.Builder> ... var1);
    }
}

