/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.dc.model.user;

import java.util.Map;
import org.jkiss.code.NotNull;

public class DCUserCreateRequest {
    @NotNull
    private final String userId;
    @NotNull
    private final Map<String, String> metaParameters;
    private final boolean enabled;
    @NotNull
    private final String authRole;

    private DCUserCreateRequest(@NotNull String userId, @NotNull Map<String, String> metaParameters, boolean enabled, @NotNull String authRole) {
        this.userId = userId;
        this.metaParameters = metaParameters;
        this.enabled = enabled;
        this.authRole = authRole;
    }

    @NotNull
    public String getUserId() {
        return this.userId;
    }

    @NotNull
    public Map<String, String> getMetaParameters() {
        return this.metaParameters;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @NotNull
    public String getAuthRole() {
        return this.authRole;
    }

    public static Builder builder(@NotNull String userId, @NotNull Map<String, String> metaParameters, @NotNull String authRole) {
        return new Builder(userId, metaParameters, authRole);
    }

    public static final class Builder {
        @NotNull
        private final String userId;
        @NotNull
        private final Map<String, String> metaParameters;
        private boolean enabled = true;
        @NotNull
        private final String authRole;

        private Builder(@NotNull String userId, @NotNull Map<String, String> metaParameters, @NotNull String authRole) {
            this.userId = userId;
            this.metaParameters = metaParameters;
            this.authRole = authRole;
        }

        public Builder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public DCUserCreateRequest build() {
            return new DCUserCreateRequest(this.userId, this.metaParameters, this.enabled, this.authRole);
        }
    }
}

