/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.dc.internal;

import com.dbeaver.model.auth.SMClientUtils;
import com.dbeaver.model.auth.SMControllerRemote;
import com.dbeaver.model.auth.SMServerAPI;
import com.dbeaver.remote.client.AbstractRemoteClient;
import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.client.dc.model.DCAuthService;
import com.dbeaver.remote.client.dc.model.session.DCSessionAuthRequest;
import com.dbeaver.remote.client.interceptor.DCAuthInterceptor;
import com.dbeaver.remote.client.interceptor.DCTrustedServiceInterceptor;
import com.dbeaver.remote.client.interceptor.DCUserAgentInterceptor;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBInternalDatabaseInformationProvider;
import org.jkiss.dbeaver.model.DBPConnectionInformation;
import org.jkiss.dbeaver.model.auth.SMAuthInfo;
import org.jkiss.dbeaver.model.security.SMAuthProviderDescriptor;
import org.jkiss.dbeaver.model.security.SMTokens;
import org.jkiss.dbeaver.model.security.exception.SMException;
import org.jkiss.dbeaver.model.security.user.SMAuthPermissions;

public class DCAuthClient
extends AbstractRemoteClient
implements DCAuthService,
SMControllerRemote,
DBInternalDatabaseInformationProvider {
    @Nullable
    private SMServerAPI serverAPI;

    public DCAuthClient(DCClientConfiguration dcClientConfiguration) {
        super(dcClientConfiguration.getApiUrl(), 0, 0, List.of(new DCAuthInterceptor(dcClientConfiguration.getRefreshSMSessionFunction(), dcClientConfiguration.getCredentialsProvider()), new DCUserAgentInterceptor(), new DCTrustedServiceInterceptor(dcClientConfiguration.getDcCertificate())));
        this.serverAPI = dcClientConfiguration.getServerAPI();
    }

    @Override
    public SMAuthInfo authenticate(@NotNull DCSessionAuthRequest sessionCreateRequest) throws DBException {
        return (SMAuthInfo)this.executePostRequest("auth", sessionCreateRequest, (Type)((Object)SMAuthInfo.class));
    }

    @Override
    @NotNull
    public SMAuthPermissions currentAuthInfo() throws DBException {
        return (SMAuthPermissions)this.executeGetRequestVal(DCAuthClient.buildEndpointUrl((String[])new String[]{"auth", "info"}), Map.of(), (Type)((Object)SMAuthPermissions.class));
    }

    @Override
    @NotNull
    public SMAuthProviderDescriptor[] getAvailableAuthProviders() throws DBException {
        return (SMAuthProviderDescriptor[])this.executeGetRequestVal(DCAuthClient.buildEndpointUrl((String[])new String[]{"auth", "providers"}), Map.of(), (Type)((Object)SMAuthProviderDescriptor[].class));
    }

    @Override
    @NotNull
    public SMAuthInfo getAuthStatus(@NotNull String authId) throws DBException {
        if (SMClientUtils.isServerLegacy((SMServerAPI)this.getServerAPI(), (String)"23.3.0")) {
            return (SMAuthInfo)this.executeGetRequestVal(DCAuthClient.buildEndpointUrl((String[])new String[]{"auth", "status", authId}), (Type)((Object)SMAuthInfo.class));
        }
        Map<String, String> queryParams = Map.of("authId", authId);
        return (SMAuthInfo)this.executeGetRequestVal(DCAuthClient.buildEndpointUrl((String[])new String[]{"auth", "status"}), queryParams, (Type)((Object)SMAuthInfo.class));
    }

    @Override
    public void logout() throws DBException {
        this.executePostRequest("auth/logout", Map.of(), (Type)((Object)SMAuthInfo.class));
    }

    @Override
    public SMTokens refreshSession(@NotNull String refreshToken) throws DBException {
        Map<String, String> queryParams = Map.of("refreshToken", refreshToken);
        return (SMTokens)this.executePostRequest("auth/refresh", queryParams, (Type)((Object)SMTokens.class));
    }

    @Override
    @Nullable
    public SMAuthInfo restoreUserSession(@NotNull String appSessionId) throws DBException {
        return (SMAuthInfo)this.executePostRequest(DCAuthClient.buildEndpointUrl((String[])new String[]{"auth/restore", appSessionId}), Map.of(), (Type)((Object)SMAuthInfo.class));
    }

    public String ping() throws DBException {
        return (String)this.executeGetRequest("auth/ping", (Type)((Object)String.class));
    }

    public SMServerAPI getServerAPI() throws DBException {
        if (this.serverAPI == null) {
            this.serverAPI = (SMServerAPI)this.executeGetRequest("auth/api", (Type)((Object)SMServerAPI.class));
        }
        return this.serverAPI;
    }

    @NotNull
    public DBPConnectionInformation getInternalDatabaseInformation() throws DBException {
        return (DBPConnectionInformation)this.executeGetRequestVal("auth/dbinfo", Map.of(), (Type)((Object)DBPConnectionInformation.class));
    }

    protected void handleRequestException(Exception e) throws DBException {
        if (e instanceof SMException) {
            throw (SMException)e;
        }
        throw new SMException(e.getMessage(), (Throwable)e);
    }
}

