/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.dc;

import com.dbeaver.remote.client.MSServiceType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.security.user.SMProjectPermissions;

public class DCUserConfiguration {
    private final Map<String, Object> userConfiguration;
    private final Map<String, Object> userPreferences;
    private final List<SMProjectPermissions> projectPermissions;
    private final Map<MSServiceType, String> serviceEndpoints;
    private final Set<String> enabledFeatures;

    public DCUserConfiguration(@NotNull Map<String, Object> metaParameters, @NotNull Map<String, Object> userPreferences, @NotNull List<SMProjectPermissions> projectPermissions, @NotNull Map<MSServiceType, String> serviceEndpoints, @NotNull Set<String> enabledFeatures) {
        this.userConfiguration = metaParameters;
        this.userPreferences = userPreferences;
        this.projectPermissions = projectPermissions;
        this.serviceEndpoints = serviceEndpoints;
        this.enabledFeatures = enabledFeatures;
    }

    public Map<String, Object> getUserMetaParameters() {
        return this.userConfiguration;
    }

    public Map<String, Object> getUserPreferences() {
        return this.userPreferences;
    }

    public Map<MSServiceType, String> getServiceEndpoints() {
        return this.serviceEndpoints;
    }

    public List<SMProjectPermissions> getProjectPermissions() {
        return this.projectPermissions;
    }

    public String getServiceEndpoint(MSServiceType serviceType) {
        return this.serviceEndpoints == null ? null : this.serviceEndpoints.get(serviceType);
    }

    public boolean isFeatureEnabled(@NotNull String featureId) {
        return this.enabledFeatures.contains(featureId);
    }
}

