/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.dc;

import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.client.dc.DCConfigurationProvider;
import com.dbeaver.remote.client.dc.internal.DCSecretControllerClient;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.secret.DBSSecretControllerAuthorized;
import org.jkiss.dbeaver.model.secret.DBSSecretObject;
import org.jkiss.dbeaver.model.secret.DBSSecretValue;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class DCSecretControllerRemote
implements DBSSecretController,
DBSSecretControllerAuthorized {
    public static final String SECRET_CONTROLLER_ID = "dc-remote";
    private static final Log log = Log.getLog(DCSecretControllerRemote.class);
    private DCSecretControllerClient dcSecretControllerClient;

    public DCSecretControllerRemote() {
    }

    public DCSecretControllerRemote(DCClientConfiguration dcClientConfig) {
        this.dcSecretControllerClient = new DCSecretControllerClient(dcClientConfig);
    }

    @Nullable
    public String getPrivateSecretValue(@NotNull String secretId) throws DBException {
        return this.dcSecretControllerClient.getPrivateSecretValue(secretId);
    }

    public void setPrivateSecretValue(@NotNull String secretId, @Nullable String secretValue) throws DBException {
        this.dcSecretControllerClient.setPrivateSecretValue(secretId, secretValue);
    }

    public void setPrivateSecretValue(@NotNull DBSSecretObject secretObject, @NotNull DBSSecretValue secretValue) throws DBException {
        this.dcSecretControllerClient.setPrivateSecretValue(secretObject, secretValue);
    }

    @NotNull
    public List<DBSSecretValue> discoverCurrentUserSecrets(@NotNull DBSSecretObject secretObject) throws DBException {
        return this.dcSecretControllerClient.discoverCurrentUserSecrets(secretObject);
    }

    @NotNull
    public List<DBSSecretValue> listAllSharedSecrets(@NotNull DBSSecretObject secretObject) throws DBException {
        return this.dcSecretControllerClient.listAllSharedSecrets(secretObject);
    }

    public void setSubjectSecretValue(@NotNull String subjectId, @NotNull DBSSecretObject secretObject, @NotNull DBSSecretValue secretValue) throws DBException {
        this.dcSecretControllerClient.setSubjectSecretValue(subjectId, secretObject, secretValue);
    }

    public void flushChanges() throws DBException {
        this.dcSecretControllerClient.flushChanges();
    }

    public void deleteSubjectSecrets(@NotNull String subjectId) throws DBException {
        this.dcSecretControllerClient.deleteSubjectSecrets(subjectId);
    }

    public void deleteProjectSecrets(@NotNull String projectId) throws DBException {
        this.dcSecretControllerClient.deleteProjectSecrets(projectId);
    }

    public void deleteObjectSecrets(@NotNull DBSSecretObject secretObject) throws DBException {
        this.dcSecretControllerClient.deleteObjectSecrets(secretObject);
    }

    /*
     * WARNING - void declaration
     */
    public void authorize(@Nullable SMCredentialsProvider credentialsProvider, @Nullable SMSessionContext smSessionContext) throws DBException {
        void dcConfigurationProvider;
        DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
        if (!(dBPApplication instanceof DCConfigurationProvider)) {
            throw new DBException("Internal error: application doesn't support remote configuration. You cannot authorize");
        }
        DCConfigurationProvider dCConfigurationProvider = (DCConfigurationProvider)dBPApplication;
        if (credentialsProvider == null) {
            throw new DBException("Internal error: credentials provider is null");
        }
        DCClientConfiguration baseConfig = dcConfigurationProvider.getBaseDCConfiguration();
        DCClientConfiguration dcConfig = ((DCClientConfiguration.Builder)((DCClientConfiguration.Builder)((DCClientConfiguration.Builder)DCClientConfiguration.builder().from(dcConfigurationProvider.getBaseDCConfiguration())).setCredentialsProvider(credentialsProvider)).setRefreshSMSessionFunction(() -> ((SMCredentialsProvider)credentialsProvider).refreshSMSession())).setUseCertificate(baseConfig.isUseCertificate()).build();
        this.dcSecretControllerClient = new DCSecretControllerClient(dcConfig);
    }
}

