/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.dc;

import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMProduct;
import com.dbeaver.lm.api.LMReleaseInfo;
import com.dbeaver.lm.api.LMSubscription;
import com.dbeaver.model.license.DBPLicenseService;
import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.client.dc.internal.DCLicenseClient;
import com.dbeaver.remote.client.dc.model.license.DCLicense;
import com.dbeaver.remote.client.dc.model.license.DCLicenseImportRequest;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class DCRemoteLicenseService
implements DBPLicenseService {
    private final DCLicenseClient dcLicenceClient;

    public DCRemoteLicenseService(DCClientConfiguration dcClientConfiguration) {
        this.dcLicenceClient = new DCLicenseClient(dcClientConfiguration);
    }

    @Nullable
    public LMLicense getActiveProductLicense(boolean validate) throws LMException {
        DCLicense license = this.dcLicenceClient.getActiveProductLicense(validate);
        if (license == null) {
            return null;
        }
        return DCLicense.toLMLicense(license);
    }

    @NotNull
    public LMLicense[] getAllProductLicenses() throws LMException {
        return (LMLicense[])Arrays.stream(this.dcLicenceClient.getAllProductLicenses()).map(DCLicense::toLMLicense).toArray(LMLicense[]::new);
    }

    public LMLicense importProductLicense(@NotNull String licenseText) throws LMException {
        return DCLicense.toLMLicense(this.dcLicenceClient.importProductLicense(DCLicenseImportRequest.builder(licenseText).build()));
    }

    public LMProduct getActiveProduct() throws LMException {
        return this.dcLicenceClient.getActiveProduct();
    }

    public boolean invalidateActiveLicense(boolean forceRefresh) throws LMException {
        return this.dcLicenceClient.invalidateLicense();
    }

    @Nullable
    public String getActiveLicenseStatus() throws LMException {
        return this.dcLicenceClient.getActiveLicenseStatus();
    }

    public void validateLicense(@NotNull LMLicense license) throws LMException {
    }

    public String getLicenseStatus(@NotNull LMLicense license) throws LMException {
        return "Ok";
    }

    public LMSubscription getSubscriptionInfo(@NotNull LMLicense license) throws LMException {
        return null;
    }

    public LMReleaseInfo getReleaseInfo(@NotNull LMLicense license) {
        return null;
    }

    public void deleteLicense(@NotNull LMLicense license) throws LMException {
        throw new LMException("Not implemented");
    }

    public void deleteLicense(@NotNull String licenseId) throws LMException {
        this.dcLicenceClient.deleteLicense(licenseId);
    }

    public LMLicense refreshProductLicense(@NotNull LMLicense license) throws LMException {
        throw new LMException("License refresh is not supported");
    }

    public String getActiveEncodedLicense() throws LMException {
        return this.dcLicenceClient.getActiveEncodedLicense();
    }
}

