/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.dc;

import com.dbeaver.remote.client.AbstractRemoteClient;
import com.dbeaver.remote.client.MSServiceType;
import com.dbeaver.remote.client.dc.DCApplicationConfiguration;
import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.client.dc.DCUserConfiguration;
import com.dbeaver.remote.client.dc.model.DCConfigurationService;
import com.dbeaver.remote.client.interceptor.ApplicationInstanceInterceptor;
import com.dbeaver.remote.client.interceptor.DCAuthInterceptor;
import com.dbeaver.remote.client.interceptor.DCTrustedServiceInterceptor;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;

public class DCConfigurationClient
extends AbstractRemoteClient
implements DCConfigurationService {
    public DCConfigurationClient(DCClientConfiguration dcClientConfiguration) {
        super(dcClientConfiguration.getApiUrl(), List.of(new DCAuthInterceptor(dcClientConfiguration.getRefreshSMSessionFunction(), dcClientConfiguration.getCredentialsProvider()), new DCTrustedServiceInterceptor(dcClientConfiguration.getDcCertificate()), new ApplicationInstanceInterceptor(dcClientConfiguration.getApplicationId())));
    }

    @Override
    public Map<String, Object> getServiceConfiguration(@NotNull MSServiceType serviceType) throws DBException {
        return (Map)this.executeGetRequest(DCConfigurationClient.buildEndpointUrl((String[])new String[]{"configurations", "service", serviceType.toString()}), new TypeToken<HashMap<String, Object>>(){}.getType());
    }

    @Override
    public void saveServiceConfiguration(@NotNull MSServiceType serviceType, Map<String, Object> configurationProperties) throws DBException {
        this.executePostRequest(DCConfigurationClient.buildEndpointUrl((String[])new String[]{"configurations", "service", serviceType.toString()}), Map.of(), configurationProperties, (Type)((Object)Void.class));
    }

    @Override
    public void updateCommonConfiguration(Map<String, Object> configurationProperties) throws DBException {
        this.executePostRequest(DCConfigurationClient.buildEndpointUrl((String[])new String[]{"configurations", "common"}), Map.of(), configurationProperties, (Type)((Object)Void.class));
    }

    @Override
    public DCUserConfiguration getUserConfiguration() throws DBException {
        return (DCUserConfiguration)this.executeGetRequest(DCConfigurationClient.buildEndpointUrl((String[])new String[]{"configurations", "user"}), (Type)((Object)DCUserConfiguration.class));
    }

    @Override
    public DCApplicationConfiguration getApplicationConfiguration() throws DBException {
        return (DCApplicationConfiguration)this.executeGetRequest(DCConfigurationClient.buildEndpointUrl((String[])new String[]{"configurations", "application"}), (Type)((Object)DCApplicationConfiguration.class));
    }
}

