/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.interceptor;

import java.io.IOException;
import java.util.Set;
import javax.net.ssl.SSLException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class RetryRequestInterceptor
implements Interceptor {
    private static final Log log = Log.getLog(RetryRequestInterceptor.class);
    private static final int BAD_GATEWAY = 502;
    private static final int BAD_GATEWAY_TIMEOUT = 504;
    private static final Set<Class<? extends IOException>> CRITICAL_ERRORS = Set.of(SSLException.class);
    private static final int PAUSE_SECONDS = 3;
    private final int retryCount;
    private final String apiUrl;

    public RetryRequestInterceptor(int retryCount, String apiUrl) {
        this.retryCount = retryCount;
        this.apiUrl = apiUrl;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        int tryCount = 0;
        Response response = null;
        while (tryCount < this.getRetryCount() / 3) {
            if (tryCount > 0) {
                RuntimeUtils.pause((int)3000);
            }
            IOException exception = null;
            try {
                ++tryCount;
                if (response != null) {
                    response.close();
                }
                if ((response = chain.proceed(request)).code() != 502 && response.code() != 504) {
                    return response;
                }
            }
            catch (IOException e) {
                if (CRITICAL_ERRORS.contains(e.getClass())) {
                    throw e;
                }
                exception = e;
            }
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Failed execute request ").append(tryCount).append(" times: ").append(request);
            if (response != null) {
                errorMessage.append("\n").append("Response: ").append(response);
            }
            if (exception != null) {
                errorMessage.append("\n").append("Exception: ").append(exception.getMessage()).append(" ").append(exception.getClass());
            }
            log.debug((Object)errorMessage);
        }
        if (response != null) {
            response.close();
        }
        throw new IOException("Server is not available: " + this.apiUrl);
    }

    protected int getRetryCount() {
        return this.retryCount;
    }
}

