/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.upd.protocol;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;

public class UPDBlob
implements Blob {
    private byte[] data;

    public UPDBlob(byte[] data) {
        this.data = data;
    }

    @Override
    public long length() throws SQLException {
        return this.data.length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        return Arrays.copyOfRange(this.data, (int)pos - 1, (int)pos - 1 + length);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (pos < 1L || pos > this.length()) {
            throw new SQLException("Position out of bounds");
        }
        if (offset < 0 || len < 0 || offset + len > bytes.length) {
            throw new SQLException("Offset or length out of bounds");
        }
        byte[] newData = new byte[(int)this.length()];
        System.arraycopy(this.data, 0, newData, 0, (int)this.length());
        System.arraycopy(bytes, offset, newData, (int)pos - 1, len);
        return len;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (len < 0L || len > this.length()) {
            throw new SQLException("Length out of bounds");
        }
        byte[] newData = new byte[(int)len];
        System.arraycopy(this.data, 0, newData, 0, (int)len);
        this.data = newData;
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (pos < 1L || pos > this.length()) {
            throw new SQLException("Position out of bounds");
        }
        if (length < 0L || length > this.length()) {
            throw new SQLException("Length out of bounds");
        }
        return new ByteArrayInputStream(this.data, (int)pos - 1, (int)length);
    }
}

