/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.entity.FieldInfo;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.rest.entity.StreamsTaskMetadata;
import io.confluent.ksql.util.KsqlConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class QueryDescription {
    private final QueryId id;
    private final String statementText;
    private final Optional<WindowType> windowType;
    private final List<FieldInfo> fields;
    private final Set<String> sources;
    private final Set<String> sinks;
    private final String topology;
    private final String executionPlan;
    private final Map<String, Object> overriddenProperties;
    private final Map<KsqlHostInfoEntity, KsqlConstants.KsqlQueryStatus> ksqlHostQueryStatus;
    private final KsqlConstants.KsqlQueryType queryType;
    private final List<QueryError> queryErrors;
    private final Set<StreamsTaskMetadata> tasksMetadata;
    private final String consumerGroupId;

    @JsonCreator
    public QueryDescription(@JsonProperty(value="id") QueryId id, @JsonProperty(value="statementText") String statementText, @JsonProperty(value="windowType") Optional<WindowType> windowType, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="sources") Set<String> sources, @JsonProperty(value="sinks") Set<String> sinks, @JsonProperty(value="topology") String topology, @JsonProperty(value="executionPlan") String executionPlan, @JsonProperty(value="overriddenProperties") Map<String, Object> overriddenProperties, @JsonProperty(value="ksqlHostQueryStatus") Map<KsqlHostInfoEntity, KsqlConstants.KsqlQueryStatus> ksqlHostQueryStatus, @JsonProperty(value="queryType") KsqlConstants.KsqlQueryType queryType, @JsonProperty(value="queryErrors") List<QueryError> queryErrors, @JsonProperty(value="tasksMetadata") Set<StreamsTaskMetadata> tasksMetadata, @JsonProperty(value="consumerGroupId") String getConsumerGroupId) {
        this.id = Objects.requireNonNull(id, "id");
        this.statementText = Objects.requireNonNull(statementText, "statementText");
        this.windowType = Objects.requireNonNull(windowType, "windowType");
        this.fields = ImmutableList.copyOf((Collection)Objects.requireNonNull(fields, "fields"));
        this.sources = ImmutableSet.copyOf((Collection)Objects.requireNonNull(sources, "sources"));
        this.sinks = ImmutableSet.copyOf((Collection)Objects.requireNonNull(sinks, "sinks"));
        this.topology = Objects.requireNonNull(topology, "topology");
        this.executionPlan = Objects.requireNonNull(executionPlan, "executionPlan");
        this.overriddenProperties = ImmutableMap.copyOf(Objects.requireNonNull(overriddenProperties, "overriddenProperties"));
        this.ksqlHostQueryStatus = new HashMap<KsqlHostInfoEntity, KsqlConstants.KsqlQueryStatus>(Objects.requireNonNull(ksqlHostQueryStatus, "ksqlHostQueryStatus"));
        this.queryType = Objects.requireNonNull(queryType, "queryType");
        this.queryErrors = new ArrayList<QueryError>((Collection)Objects.requireNonNull(queryErrors, "queryErrors"));
        this.tasksMetadata = new HashSet<StreamsTaskMetadata>((Collection)Objects.requireNonNull(tasksMetadata));
        this.consumerGroupId = Objects.requireNonNull(getConsumerGroupId, "consumerGroupId");
    }

    public QueryId getId() {
        return this.id;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public String getStatementText() {
        return this.statementText;
    }

    public Optional<WindowType> getWindowType() {
        return this.windowType;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="fields is ImmutableList")
    public List<FieldInfo> getFields() {
        return this.fields;
    }

    public String getTopology() {
        return this.topology;
    }

    public String getExecutionPlan() {
        return this.executionPlan;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="sources is ImmutableSet")
    public Set<String> getSources() {
        return this.sources;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="sinks is ImmutableSet")
    public Set<String> getSinks() {
        return this.sinks;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="overriddenProperties is ImmutableMap")
    public Map<String, Object> getOverriddenProperties() {
        return this.overriddenProperties;
    }

    public void updateTaskMetadata(Set<StreamsTaskMetadata> updatedMetadata) {
        this.tasksMetadata.addAll(updatedMetadata);
    }

    public ImmutableSet<StreamsTaskMetadata> getTasksMetadata() {
        return ImmutableSet.copyOf(this.tasksMetadata);
    }

    @JsonProperty(value="state")
    public Optional<String> getState() {
        if (this.ksqlHostQueryStatus.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((this.ksqlHostQueryStatus.containsValue(KsqlConstants.KsqlQueryStatus.ERROR) ? KsqlConstants.KsqlQueryStatus.ERROR : KsqlConstants.KsqlQueryStatus.RUNNING).toString());
    }

    public void updateKsqlHostQueryStatus(KsqlHostInfoEntity host, KsqlConstants.KsqlQueryStatus status) {
        this.ksqlHostQueryStatus.put(host, status);
    }

    public Map<KsqlHostInfoEntity, KsqlConstants.KsqlQueryStatus> getKsqlHostQueryStatus() {
        return Collections.unmodifiableMap(this.ksqlHostQueryStatus);
    }

    public KsqlConstants.KsqlQueryType getQueryType() {
        return this.queryType;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="should be mutable")
    public List<QueryError> getQueryErrors() {
        return this.queryErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryDescription)) {
            return false;
        }
        QueryDescription that = (QueryDescription)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.statementText, that.statementText) && Objects.equals(this.windowType, that.windowType) && Objects.equals(this.fields, that.fields) && Objects.equals(this.topology, that.topology) && Objects.equals(this.executionPlan, that.executionPlan) && Objects.equals(this.sources, that.sources) && Objects.equals(this.sinks, that.sinks) && Objects.equals(this.overriddenProperties, that.overriddenProperties) && Objects.equals(this.ksqlHostQueryStatus, that.ksqlHostQueryStatus) && Objects.equals(this.queryType, that.queryType) && Objects.equals(this.queryErrors, that.queryErrors) && Objects.equals(this.tasksMetadata, that.tasksMetadata) && Objects.equals(this.consumerGroupId, that.consumerGroupId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.statementText, this.windowType, this.fields, this.topology, this.executionPlan, this.sources, this.sinks, this.overriddenProperties, this.ksqlHostQueryStatus, this.queryType, this.queryErrors, this.tasksMetadata, this.consumerGroupId);
    }
}

