/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.redshift;

import com.dbeaver.cloud.aws.AWSCloudAbstractInstance;
import com.dbeaver.cloud.aws.AWSCloudService;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.net.auth.aws.AWSIAMUtils;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.redshiftserverless.model.Workgroup;

public class AWSCloudRedshiftServerlessCluster
extends AWSCloudAbstractInstance {
    private final String accountId;
    private final Workgroup workgroup;

    public AWSCloudRedshiftServerlessCluster(AWSCloudSession session, AWSCloudZone zone, String accountId, Workgroup workgroup) {
        super(session, zone);
        this.accountId = accountId;
        this.workgroup = workgroup;
    }

    @NotNull
    public String getNodeId() {
        return this.getAwsRegionId() + "." + this.workgroup.workgroupName();
    }

    @NotNull
    public String getNodeName() {
        return this.getAwsRegionId() + " " + this.workgroup.workgroupName();
    }

    @Nullable
    public String getInstanceEndpoint() {
        return this.workgroup.workgroupName() + "." + this.accountId + "." + this.getAwsRegionId() + ".redshift-serverless.amazonaws.com";
    }

    @Override
    @NotNull
    public String getNodeDisplayName() {
        return this.getAwsRegionId() + " " + this.workgroup.workgroupName();
    }

    @Override
    protected void setDataSourceConfiguration(DBPConnectionConfiguration configuration) throws DBException {
        configuration.setDatabaseName("dev");
        configuration.setHostName(this.getInstanceEndpoint());
        configuration.setHostPort(CommonUtils.toString((Object)5439));
        configuration.setUserName(this.getInstanceUserName());
        configuration.setAuthModelId("redshift_iam");
        configuration.setAuthProperty("iam.region", this.getZone().getZoneId());
    }

    @Override
    protected AWSCloudService getCloudService() {
        return AWSCloudService.REDSHIFT_SERVERLESS;
    }

    @Override
    @Nullable
    protected String getInstanceUserName() {
        return null;
    }

    @Override
    protected String getInstanceARN() {
        return "arn:" + AWSIAMUtils.getArnPartition((String)this.getAwsRegionId()) + ":redshift-serverless:" + this.getAwsRegionId() + ":" + this.accountId + "/" + this.workgroup.workgroupId();
    }

    @Override
    @NotNull
    protected String getResourceId() {
        return this.workgroup.workgroupName();
    }

    @Override
    protected String getExternalLink() {
        return this.getLinkPrefix();
    }
}

