/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.parameters;

import com.dbeaver.cloud.aws.AWSCloudUtils;
import com.dbeaver.cloud.model.DBPCloudParametersConfiguration;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;

public class AWSParametersProviderConfiguration
extends DBPCloudParametersConfiguration {
    @NotNull
    private String region;

    public AWSParametersProviderConfiguration(@NotNull String configId) {
        super("aws-parameters-provider", configId);
        this.mappingRule.addRule("dbname", "database");
        this.mappingRule.addRule("username", "user");
    }

    @Property(required=true)
    @NotNull
    public String getRegion() {
        return CommonUtils.trim((String)this.region);
    }

    public void setRegion(@NotNull String region) {
        this.region = CommonUtils.trim((String)region);
    }

    @Property(hidden=true)
    public boolean isGlobalConfiguration() {
        return true;
    }

    public void setGlobalConfiguration(boolean isGlobal) {
    }

    @Property(required=true)
    public synchronized String getCloudId() {
        String cloudId = super.getCloudId();
        if (CommonUtils.isEmpty((String)cloudId)) {
            try {
                cloudId = AWSCloudUtils.getAllClouds().size() == 1 ? AWSCloudUtils.getAllClouds().get(0).getCloudId() : null;
                super.setCloudId(cloudId);
            }
            catch (DBException dBException) {
                super.setCloudId(null);
            }
        }
        return cloudId;
    }
}

