/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.neptune;

import com.dbeaver.cloud.aws.AWSCloudAbstractInstance;
import com.dbeaver.cloud.aws.AWSCloudService;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.neptune.model.DBCluster;

public class AWSCloudNeptuneEndpoint
extends AWSCloudAbstractInstance {
    private final DBCluster endpoint;

    public AWSCloudNeptuneEndpoint(AWSCloudSession session, AWSCloudZone region, DBCluster endpoint) {
        super(session, region);
        this.endpoint = endpoint;
    }

    @NotNull
    public String getNodeId() {
        return this.endpoint.endpoint();
    }

    @NotNull
    public String getNodeName() {
        return this.getNodeId();
    }

    @Nullable
    public String getInstanceEndpoint() {
        return this.endpoint.endpoint();
    }

    @Override
    protected void setDataSourceConfiguration(DBPConnectionConfiguration configuration) throws DBException {
        configuration.setHostName(this.endpoint.endpoint());
        if (this.endpoint.port() != null) {
            configuration.setHostPort(CommonUtils.toString((Object)this.endpoint.port()));
        }
        configuration.setAuthModelId("iam_neptune");
        configuration.setAuthProperty("iam.region", this.getZone().getZoneId());
    }

    @Override
    protected AWSCloudService getCloudService() {
        return AWSCloudService.NEPTUNE;
    }

    @Override
    protected String getInstanceARN() {
        return this.endpoint.dbClusterArn();
    }

    @Override
    protected String getExternalLink() {
        return this.getLinkPrefix() + "database:id=" + this.endpoint.dbClusterIdentifier() + ";is-cluster=true";
    }
}

