/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.config;

import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudServiceAccount;
import com.dbeaver.cloud.aws.AWSSecretController;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudServiceAccount;
import com.dbeaver.cloud.registry.BaseCloudConfigurationProvider;
import com.dbeaver.ee.runtime.core.DBeaverEnterprisePreferences;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.utils.CommonUtils;

public class AwsLocalConfigurationProvider
extends BaseCloudConfigurationProvider<AWSCloudConfiguration> {
    private static final Log log = Log.getLog(AwsLocalConfigurationProvider.class);

    protected String getCloudTypeId() {
        return "aws";
    }

    public Class<AWSCloudConfiguration> getCloudConfigurationClass() {
        return AWSCloudConfiguration.class;
    }

    public Class<? extends CPCloudServiceAccount> getCloudServiceAccountClass() {
        return AWSCloudServiceAccount.class;
    }

    protected boolean loadSecureProperties(AWSCloudConfiguration cfg) throws DBException {
        String sessionToken;
        boolean secureLoaded = super.loadSecureProperties((CPCloudConfiguration)cfg);
        AuthModelAWSCredentials awsCredentials = cfg.getDefaultCredentials();
        if (awsCredentials.isSessionCredentials() || awsCredentials.isDefaultAwsCredentials()) {
            return secureLoaded;
        }
        DBSSecretController secretController = this.getSecretController();
        if (secretController instanceof AWSSecretController) {
            log.error((Object)"Secure properties ignored. Cannot use AWS secret controller with AWS cloud configuration with static credentials!");
            return secureLoaded;
        }
        String accessKey = secretController.getPrivateSecretValue(this.getSecretId((CPCloudConfiguration)cfg, "access-key"));
        String secretKey = CommonUtils.isEmpty((String)accessKey) ? null : secretController.getPrivateSecretValue(this.getSecretId((CPCloudConfiguration)cfg, "secret-key"));
        String string = sessionToken = CommonUtils.isEmpty((String)accessKey) ? null : secretController.getPrivateSecretValue(this.getSecretId((CPCloudConfiguration)cfg, "session-token"));
        if (!CommonUtils.isEmpty((String)accessKey)) {
            awsCredentials.setAwsAccessKey(accessKey);
        }
        if (!CommonUtils.isEmpty((String)secretKey)) {
            awsCredentials.setAwsSecretKey(secretKey);
        }
        if (!CommonUtils.isEmpty((String)sessionToken)) {
            awsCredentials.setAwsSessionToken(sessionToken);
        }
        return true;
    }

    protected boolean saveSecureProperties(AWSCloudConfiguration cfg) throws DBException {
        block6: {
            String sessionToken;
            String secretKey;
            AuthModelAWSCredentials awsCredentials;
            DBSSecretController secretController;
            block7: {
                boolean isSecure = super.saveSecureProperties((CPCloudConfiguration)cfg);
                try {
                    secretController = this.getSecretController();
                    awsCredentials = cfg.getDefaultCredentials();
                    if (awsCredentials.isSessionCredentials() || awsCredentials.isDefaultAwsCredentials()) break block6;
                    if (!(secretController instanceof AWSSecretController)) break block7;
                    log.error((Object)"Secure properties not saved. Cannot use AWS secret controller with AWS cloud configuration with static credentials!");
                    return false;
                }
                catch (Exception e) {
                    if (e instanceof DBException) {
                        throw e;
                    }
                    log.error((Object)e);
                    return isSecure;
                }
            }
            String accessKey = awsCredentials.getAwsAccessKey();
            if (!CommonUtils.isEmpty((String)accessKey)) {
                secretController.setPrivateSecretValue(this.getSecretId((CPCloudConfiguration)cfg, "access-key"), accessKey);
            }
            if (!CommonUtils.isEmpty((String)(secretKey = awsCredentials.getAwsSecretKey()))) {
                secretController.setPrivateSecretValue(this.getSecretId((CPCloudConfiguration)cfg, "secret-key"), secretKey);
            }
            if (CommonUtils.isEmpty((String)(sessionToken = awsCredentials.getAwsSessionToken()))) break block6;
            secretController.setPrivateSecretValue(this.getSecretId((CPCloudConfiguration)cfg, "session-token"), sessionToken);
        }
        return true;
    }

    private boolean useSecureStorage() {
        return DBeaverEnterprisePreferences.useSecurePreferences();
    }
}

