/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSSecretManagerConfiguration;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.model.auth.SMAuthUtils;
import com.dbeaver.model.auth.SMContextVariableResolver;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMCredentials;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecret;
import org.jkiss.dbeaver.model.secret.DBSSecretBrowser;
import org.jkiss.dbeaver.model.secret.DBSSecretControllerAuthorized;
import org.jkiss.dbeaver.model.secret.DBSSecretObject;
import org.jkiss.dbeaver.model.secret.DBSSecretValue;
import org.jkiss.dbeaver.runtime.DBSecurityException;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.PartitionMetadata;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.Filter;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.InvalidRequestException;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse;
import software.amazon.awssdk.services.secretsmanager.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.secretsmanager.model.ResourceExistsException;
import software.amazon.awssdk.services.secretsmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.secretsmanager.model.RestoreSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.SecretListEntry;
import software.amazon.awssdk.services.secretsmanager.model.UpdateSecretRequest;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;

public class AWSSecretController
implements DBSSecretControllerAuthorized,
DBSSecretBrowser {
    private static final Log log = Log.getLog(AWSSecretController.class);
    public static final String FIELD_PREFIX_TAG = "tag.";
    private static final Set<String> SECRET_FILTER_NAMES = Set.of("name", "description", "primary-region", "owning-service", "all");
    private static final String PROP_DISCOVERY_RULE = "secretDiscoveryRule";
    private SMSessionContext smSessionContext;
    private SMCredentialsProvider credentialsProvider;
    private AWSCloud cloud;
    private String awsPrincipalARN;
    private static final Pattern ASSUMED_ROLE_PATTERN = Pattern.compile("arn:(aws|aws-cn|aws-us-gov):sts::([0-9]+):assumed-role/(.+)/(.+)");

    private void checkEditEnabled() throws DBException {
        if (this.getSecretManagerConfiguration().isSecretEditDisabled()) {
            throw new DBException("Secrets edit was disabled by server configuration");
        }
    }

    public long getSupportedFeatures() throws DBException {
        boolean editEnabled = this.getSecretManagerConfiguration().isSecretEditDisabled();
        return 5L | (editEnabled ? 2L : 0L);
    }

    @Nullable
    public String getPrivateSecretValue(@NotNull String secretId) throws DBException {
        AWSSecretManagerConfiguration smc = this.getSecretManagerConfiguration();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (SecretsManagerClient client = this.getSecretsManagerClient();){
                GetSecretValueRequest getSecretValueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(this.getFullSecretId(smc, secretId)).build();
                GetSecretValueResponse getSecretValueResponse = client.getSecretValue(getSecretValueRequest);
                return getSecretValueResponse.secretString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
        catch (InvalidRequestException e) {
            log.debug((Object)("Cannot read AWS secret: " + e.getMessage()));
            return null;
        }
        catch (Exception e) {
            throw new DBException("Error reading secret value from AWS", (Throwable)e);
        }
    }

    public void setPrivateSecretValue(@NotNull String secretId, @Nullable String secretValue) throws DBException {
        this.checkEditEnabled();
        if (secretValue == null) {
            this.deleteSecret(secretId);
        } else {
            AWSSecretManagerConfiguration smc = this.getSecretManagerConfiguration();
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (SecretsManagerClient client = this.getSecretsManagerClient();){
                    try {
                        this.addSecret(smc, secretId, secretValue, client);
                    }
                    catch (ResourceExistsException resourceExistsException) {
                        this.updateSecret(smc, secretId, secretValue, client);
                    }
                    catch (InvalidRequestException e) {
                        try {
                            this.restoreSecret(smc, secretId, client);
                        }
                        catch (Exception exception) {
                            throw e;
                        }
                        this.updateSecret(smc, secretId, secretValue, client);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new DBException("Error saving secret value to AWS", (Throwable)e);
            }
        }
    }

    @NotNull
    public List<DBSSecretValue> discoverCurrentUserSecrets(@NotNull DBSSecretObject secretObject) throws DBException {
        Object rule;
        String discoveryRules;
        DBPDataSourceContainer ds;
        AWSSecretManagerConfiguration smc = this.getSecretManagerConfiguration();
        Map<String, String> configRules = smc.getDiscoveryRules();
        if (CommonUtils.isEmpty(configRules)) {
            return List.of();
        }
        String ruleName = null;
        if (secretObject instanceof DBPDataSourceContainer && CommonUtils.isEmpty((String)(ruleName = (String)(ds = (DBPDataSourceContainer)secretObject).getExtension(PROP_DISCOVERY_RULE)))) {
            ruleName = (String)ds.getProject().getProjectProperty(PROP_DISCOVERY_RULE);
        }
        if (CommonUtils.isEmpty(ruleName)) {
            ruleName = (String)CommonUtils.notNull((Object)smc.getDefaultDiscoveryRule(), (Object)"default");
        }
        if (CommonUtils.isEmpty((String)(discoveryRules = configRules.get(ruleName)))) {
            log.debug((Object)("Cannot find default discovery rule '" + ruleName + "'"));
            return List.of();
        }
        SMContextVariableResolver secretVarResolver = new SMContextVariableResolver((DBRProgressMonitor)new LoggingProgressMonitor(log), secretObject);
        String[] rules = discoveryRules.split(",");
        LinkedHashMap<String, String> conditions = new LinkedHashMap<String, String>();
        String[] stringArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            rule = stringArray[n2];
            String[] values = ((String)rule).split("=");
            if (values.length != 2) {
                log.debug((Object)("Invalid secret discovery rule: " + (String)rule));
            } else {
                conditions.put(GeneralUtils.replaceVariables((String)values[0], (IVariableResolver)secretVarResolver), GeneralUtils.replaceVariables((String)values[1], (IVariableResolver)secretVarResolver));
            }
            ++n2;
        }
        if (conditions.isEmpty()) {
            log.debug((Object)"No secret search conditions");
            return List.of();
        }
        log.debug((Object)("Discover AWS secrets for conditions " + String.valueOf(conditions)));
        try {
            rule = null;
            Object var11_14 = null;
            try {
                DBPDataSourceContainer ds2;
                try (SecretsManagerClient client = this.getSecretsManagerClient(secretObject instanceof DBPDataSourceContainer ? (ds2 = (DBPDataSourceContainer)secretObject) : null);){
                    ArrayList<Filter> filters = new ArrayList<Filter>();
                    for (Map.Entry sc : conditions.entrySet()) {
                        String fieldName = (String)sc.getKey();
                        if (fieldName.startsWith(FIELD_PREFIX_TAG)) {
                            filters.add((Filter)Filter.builder().key("tag-key").values(new String[]{fieldName.substring(FIELD_PREFIX_TAG.length())}).build());
                            filters.add((Filter)Filter.builder().key("tag-value").values(new String[]{(String)sc.getValue()}).build());
                            continue;
                        }
                        if (SECRET_FILTER_NAMES.contains(fieldName)) {
                            filters.add((Filter)Filter.builder().key(fieldName).values(new String[]{(String)sc.getValue()}).build());
                            continue;
                        }
                        throw new DBException("Field '" + fieldName + "' is not supported by AWS secret search API. Use tag.<tag-name>=<tag-value> or one of fields from " + String.valueOf(SECRET_FILTER_NAMES));
                    }
                    ListSecretsRequest lsRequest = (ListSecretsRequest)ListSecretsRequest.builder().filters(filters).build();
                    ListSecretsResponse lsResponse = client.listSecrets(lsRequest);
                    SMCredentials activeUserCredentials = this.credentialsProvider.getActiveUserCredentials();
                    if (activeUserCredentials == null || activeUserCredentials.getUserId() == null) {
                        throw new DBException("No active user credentials found. Shared secrets are not accessible.");
                    }
                    ArrayList<DBSSecretValue> result = new ArrayList<DBSSecretValue>();
                    for (SecretListEntry sle : lsResponse.secretList()) {
                        DBSSecretValue secretValue = new DBSSecretValue(activeUserCredentials.getUserId(), sle.arn(), sle.name(), null);
                        GetSecretValueRequest getSecretValueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(sle.name()).build();
                        GetSecretValueResponse secretValueResponse = client.getSecretValue(getSecretValueRequest);
                        secretValue.setValue(secretValueResponse.secretString());
                        result.add(secretValue);
                    }
                    return result;
                }
            }
            catch (Throwable throwable) {
                if (rule == null) {
                    rule = throwable;
                } else if (rule != throwable) {
                    ((Throwable)rule).addSuppressed(throwable);
                }
                throw rule;
            }
        }
        catch (Exception e) {
            throw new DBException("Error during secrets discovery: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setSubjectSecretValue(@NotNull String subjectId, @NotNull DBSSecretObject secretObject, @NotNull DBSSecretValue secretValue) throws DBException {
        throw new DBCFeatureNotSupportedException("Shared credentials edit not supported for AWS");
    }

    public void flushChanges() throws DBException {
    }

    @NotNull
    public List<DBSSecret> listSecrets(@Nullable String path) throws DBException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (SecretsManagerClient client = this.getSecretsManagerClient();){
            ListSecretsRequest listSecretsRequest = (ListSecretsRequest)ListSecretsRequest.builder().build();
            ListSecretsResponse listSecretsResponse = client.listSecrets(listSecretsRequest);
            return listSecretsResponse.secretList().stream().map(this::mapToDBSSecret).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nullable
    public DBSSecret getSecret(@NotNull String secretId) throws DBException {
        AWSSecretManagerConfiguration smc = this.getSecretManagerConfiguration();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (SecretsManagerClient client = this.getSecretsManagerClient();){
                GetSecretValueRequest getSecretValueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(this.getFullSecretId(smc, secretId)).build();
                GetSecretValueResponse secretValueResponse = client.getSecretValue(getSecretValueRequest);
                return new DBSSecret(secretValueResponse.secretString(), secretValueResponse.name());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
        catch (Exception e) {
            throw new DBException("Error during secret read", (Throwable)e);
        }
    }

    private void addSecret(AWSSecretManagerConfiguration smc, String secretId, String secretValue, SecretsManagerClient client) throws DBException {
        String curUserARN;
        String fullSecretId = this.getFullSecretId(smc, secretId);
        CreateSecretRequest.Builder asBuilder = CreateSecretRequest.builder().name(fullSecretId).secretString(secretValue);
        if (!CommonUtils.isEmpty((String)smc.getEncryptionKey())) {
            asBuilder.kmsKeyId(smc.getEncryptionKey());
        }
        CreateSecretRequest createSecretRequest = (CreateSecretRequest)asBuilder.build();
        client.createSecret(createSecretRequest);
        String resourcePolicy = CommonUtils.toString((Object)smc.getResourcePolicy(), (String)AWSSecretManagerConfiguration.DEFAULT_CONFIGURATION.getResourcePolicy());
        String assumedRole = this.getAwsPrincipalAssumedRole(true);
        String string = curUserARN = assumedRole != null ? assumedRole : this.awsPrincipalARN;
        if (!CommonUtils.isEmpty((String)resourcePolicy)) {
            resourcePolicy = GeneralUtils.replaceVariables((String)resourcePolicy, name -> {
                if ("aws.PrincipalArn".equals(name)) {
                    return curUserARN;
                }
                return null;
            });
            PutResourcePolicyRequest prpr = (PutResourcePolicyRequest)PutResourcePolicyRequest.builder().secretId(fullSecretId).resourcePolicy(resourcePolicy).build();
            try {
                client.putResourcePolicy(prpr);
            }
            catch (Exception e) {
                try {
                    this.deleteSecret(secretId);
                }
                catch (DBException ex) {
                    log.debug((Object)"Cannot cleanup secret", (Throwable)ex);
                }
                throw e;
            }
        }
    }

    private void restoreSecret(AWSSecretManagerConfiguration smc, String secretId, SecretsManagerClient client) throws DBException {
        RestoreSecretRequest updateSecretRequest = (RestoreSecretRequest)RestoreSecretRequest.builder().secretId(this.getFullSecretId(smc, secretId)).build();
        client.restoreSecret(updateSecretRequest);
    }

    private void updateSecret(AWSSecretManagerConfiguration smc, String secretId, String newSecretValue, SecretsManagerClient client) throws DBException {
        UpdateSecretRequest updateSecretRequest = (UpdateSecretRequest)UpdateSecretRequest.builder().secretId(this.getFullSecretId(smc, secretId)).secretString(newSecretValue).build();
        client.updateSecret(updateSecretRequest);
    }

    public void deleteSecret(@NotNull String secretId) throws DBException {
        this.checkEditEnabled();
        AWSSecretManagerConfiguration smc = this.getSecretManagerConfiguration();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (SecretsManagerClient client = this.getSecretsManagerClient();){
                DeleteSecretRequest deleteSecretRequest = (DeleteSecretRequest)DeleteSecretRequest.builder().secretId(this.getFullSecretId(smc, secretId)).forceDeleteWithoutRecovery(Boolean.valueOf(true)).build();
                client.deleteSecret(deleteSecretRequest);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
        }
        catch (Exception e) {
            throw new DBException("Error during secret delete", (Throwable)e);
        }
    }

    public void clearAllSecrets(String keyPrefix) throws DBException {
        this.checkEditEnabled();
        Throwable throwable = null;
        Object var3_4 = null;
        try (SecretsManagerClient client = this.getSecretsManagerClient();){
            ListSecretsResponse listSecretsResponse = client.listSecrets();
            Iterator iterator = listSecretsResponse.secretList().iterator();
            while (iterator.hasNext()) {
                SecretListEntry cfr_ignored_0 = (SecretListEntry)iterator.next();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void authorize(SMCredentialsProvider credentialsProvider, SMSessionContext smSessionContext) throws DBException {
        this.smSessionContext = smSessionContext;
        this.credentialsProvider = credentialsProvider;
    }

    private String getFullSecretId(AWSSecretManagerConfiguration smc, String secretId) throws DBException {
        String secretNamePrefix;
        SMCredentials activeUserCredentials = this.credentialsProvider.getActiveUserCredentials();
        if (activeUserCredentials == null) {
            throw new DBSecurityException("No active user in session. Private secrets are not available.");
        }
        boolean isRoleKey = this.isAwsPrincipalIsAssumedRole();
        StringBuilder fullId = new StringBuilder();
        AWSSecretManagerConfiguration defConfig = AWSSecretManagerConfiguration.DEFAULT_CONFIGURATION;
        String string = secretNamePrefix = isRoleKey ? CommonUtils.toString((Object)smc.getRoleSecretPrefix(), (String)defConfig.getRoleSecretPrefix()) : CommonUtils.toString((Object)smc.getPrivateSecretPrefix(), (String)defConfig.getPrivateSecretPrefix());
        if (secretNamePrefix != null) {
            fullId.append(secretNamePrefix);
            fullId.append("/");
        }
        if (isRoleKey) {
            fullId.append(this.getAwsPrincipalAssumedRole(false));
        } else {
            fullId.append(activeUserCredentials.getUserId());
            fullId.append("/");
            AWSCloudSession awsCloudSession = this.getAwsCloudSession(this.cloud);
            String authTypeOrDomain = awsCloudSession.getSessionPrincipal().getUserDomain();
            fullId.append(authTypeOrDomain);
        }
        fullId.append("/");
        fullId.append(secretId);
        return fullId.toString();
    }

    private AWSSecretManagerConfiguration getSecretManagerConfiguration() throws DBException {
        AWSSecretManagerConfiguration smc = ((AWSCloudConfiguration)this.getAwsCloud().getCloudConfiguration()).getSecretManagerConfiguration();
        return smc != null ? smc : AWSSecretManagerConfiguration.DEFAULT_CONFIGURATION;
    }

    private boolean isAwsPrincipalIsAssumedRole() throws DBException {
        return ASSUMED_ROLE_PATTERN.matcher(this.getAwsPrincipalARN()).matches();
    }

    private String getAwsPrincipalARN() throws DBException {
        if (this.awsPrincipalARN == null) {
            AWSCloud cloud = this.getAwsCloud();
            AWSCloudSession awsCloudSession = this.getAwsCloudSession(cloud);
            this.awsPrincipalARN = awsCloudSession.getArn();
            if (CommonUtils.isEmpty((String)this.awsPrincipalARN)) {
                GetCallerIdentityResponse gci = cloud.readGetCallerIdentity((DBRProgressMonitor)new VoidProgressMonitor(), awsCloudSession);
                this.awsPrincipalARN = gci.arn();
            }
        }
        return this.awsPrincipalARN;
    }

    private String getAwsPrincipalAssumedRole(boolean fullARN) throws DBException {
        Matcher matcher = ASSUMED_ROLE_PATTERN.matcher(this.getAwsPrincipalARN());
        if (matcher.matches()) {
            String accountID = matcher.group(1);
            String roleName = matcher.group(2);
            if (fullARN) {
                return "arn:" + this.getArnPartition() + ":iam::" + accountID + ":role/" + roleName;
            }
            return roleName;
        }
        return null;
    }

    private SecretsManagerClient getSecretsManagerClient() throws DBException {
        return this.getSecretsManagerClient(null);
    }

    private SecretsManagerClient getSecretsManagerClient(@Nullable DBPDataSourceContainer dataSource) throws DBException {
        DBAAuthCredentials dsCredentials;
        AWSCloud cloud = this.getAwsCloud();
        String primaryRegion = this.getSecretManagerConfiguration().getPrimaryRegion();
        Region region = Region.of((String)primaryRegion);
        AWSCloudSession awsCloudSession = this.getAwsCloudSession(cloud);
        AwsCredentialsProvider awsCredentialsProvider = awsCloudSession.getIamCredentials().getAuthCredentialsProvider((DBRProgressMonitor)new VoidProgressMonitor(), null, primaryRegion);
        if (dataSource != null && (dsCredentials = dataSource.getConnectionConfiguration().getAuthModel().loadCredentials(dataSource, dataSource.getConnectionConfiguration())) instanceof AuthModelAWSCredentials) {
            AuthModelAWSCredentials awsCredentials = (AuthModelAWSCredentials)dsCredentials;
            String dsRegion = awsCredentials.getRegion();
            if (!CommonUtils.isEmpty((String)dsRegion)) {
                region = Region.of((String)dsRegion);
            }
            String jwtToken = null;
            awsCredentialsProvider = awsCredentials.assumeAccountRole((DBRProgressMonitor)new VoidProgressMonitor(), awsCredentialsProvider, region.id(), jwtToken);
        }
        return (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(region)).credentialsProvider(awsCredentialsProvider)).build();
    }

    private String getCurrentSessionAccessToken() throws DBException {
        SMSession mainSession = this.smSessionContext.getSpaceSession((DBRProgressMonitor)new LoggingProgressMonitor(log), this.smSessionContext.getPrimaryAuthSpace(), false);
        if (mainSession == null) {
            return null;
        }
        return CommonUtils.toString((Object)SMAuthUtils.findAuthAttribute((SMSession)mainSession, (String)"jwt-token"));
    }

    @NotNull
    private AWSCloudSession getAwsCloudSession(AWSCloud cloud) throws DBException {
        SMSession cloudSession = this.smSessionContext.getSpaceSession((DBRProgressMonitor)new LoggingProgressMonitor(log), (SMAuthSpace)cloud, true);
        if (cloudSession instanceof AWSCloudSession) {
            AWSCloudSession awsCloudSession = (AWSCloudSession)cloudSession;
            return awsCloudSession;
        }
        throw new DBException("AWS cloud session not found. You need to authenticate in AWS cloud to use AWS secret manager.");
    }

    @NotNull
    private AWSCloud getAwsCloud() throws DBException {
        if (this.cloud == null) {
            this.cloud = (AWSCloud)CPCloudUtils.getCloud((String)"AWS");
            if (this.cloud == null) {
                throw new DBException("AWS cloud not found. AWS secret manager disabled.");
            }
        }
        return this.cloud;
    }

    private DBSSecret mapToDBSSecret(SecretListEntry secretListEntry) {
        DBSSecret dbSecret = new DBSSecret();
        dbSecret.setId(secretListEntry.kmsKeyId());
        dbSecret.setName(secretListEntry.name());
        dbSecret.setDescription(secretListEntry.description());
        return dbSecret;
    }

    @NotNull
    private String getArnPartition() throws DBException {
        return PartitionMetadata.of((Region)((AWSCloudConfiguration)this.getAwsCloud().getCloudConfiguration()).getStsRegion()).id();
    }
}

