/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.nio;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.nio.AzureFileStore;
import com.azure.storage.blob.nio.AzureFileSystem;
import com.azure.storage.blob.nio.AzureFileSystemProvider;
import com.azure.storage.blob.nio.LoggingUtility;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.FileSystem;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public final class AzurePath
implements Path {
    private static final ClientLogger LOGGER = new ClientLogger(AzurePath.class);
    static final String ROOT_DIR_SUFFIX = ":";
    private final AzureFileSystem parentFileSystem;
    private final String pathString;

    AzurePath(AzureFileSystem parentFileSystem, String first, String ... more) {
        this.parentFileSystem = parentFileSystem;
        ArrayList<String> elements = new ArrayList<String>(Arrays.asList(first.split(parentFileSystem.getSeparator())));
        if (more != null) {
            for (String next : more) {
                elements.addAll(Arrays.asList(next.split(parentFileSystem.getSeparator())));
            }
        }
        elements.removeIf(String::isEmpty);
        this.pathString = String.join((CharSequence)this.parentFileSystem.getSeparator(), elements);
        for (int i = 0; i < elements.size(); ++i) {
            String element = (String)elements.get(i);
            if (i == 0) {
                if (!element.contains(ROOT_DIR_SUFFIX) || element.indexOf(ROOT_DIR_SUFFIX) >= element.length() - 1) continue;
                throw LoggingUtility.logError(LOGGER, new InvalidPathException(this.pathString, ": may only be used as the last character in the root component of a path"));
            }
            if (!element.contains(ROOT_DIR_SUFFIX)) continue;
            throw LoggingUtility.logError(LOGGER, new InvalidPathException(this.pathString, ": is an invalid character except to identify the root element of this path if there is one."));
        }
    }

    @Override
    public FileSystem getFileSystem() {
        return this.parentFileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.getRoot() != null;
    }

    @Override
    public Path getRoot() {
        String[] elements = this.splitToElements();
        if (elements.length > 0 && elements[0].endsWith(ROOT_DIR_SUFFIX)) {
            return this.parentFileSystem.getPath(elements[0], new String[0]);
        }
        return null;
    }

    @Override
    public Path getFileName() {
        if (this.isRoot()) {
            return null;
        }
        if (this.pathString.isEmpty()) {
            return this;
        }
        List<String> elements = Arrays.asList(this.splitToElements());
        return this.parentFileSystem.getPath(elements.get(elements.size() - 1), new String[0]);
    }

    @Override
    public Path getParent() {
        String[] elements = this.splitToElements();
        if (elements.length == 1 || elements.length == 0) {
            return null;
        }
        return this.parentFileSystem.getPath(this.pathString.substring(0, this.pathString.lastIndexOf(this.parentFileSystem.getSeparator())), new String[0]);
    }

    @Override
    public int getNameCount() {
        if (this.pathString.isEmpty()) {
            return 1;
        }
        return this.splitToElements(this.withoutRoot()).length;
    }

    @Override
    public Path getName(int index) {
        if (index < 0 || index >= this.getNameCount()) {
            throw LoggingUtility.logError(LOGGER, new IllegalArgumentException(String.format("Index %d is out of bounds", index)));
        }
        if (this.pathString.isEmpty()) {
            return this;
        }
        return this.parentFileSystem.getPath(this.splitToElements(this.withoutRoot())[index], new String[0]);
    }

    @Override
    public Path subpath(int begin, int end) {
        if (begin < 0 || begin >= this.getNameCount() || end <= begin || end > this.getNameCount()) {
            throw LoggingUtility.logError(LOGGER, new IllegalArgumentException(String.format("Values of begin: %d and end: %d are invalid", begin, end)));
        }
        CharSequence[] subnames = (String[])Stream.of(this.splitToElements(this.withoutRoot())).skip(begin).limit(end - begin).toArray(String[]::new);
        return this.parentFileSystem.getPath(String.join((CharSequence)this.parentFileSystem.getSeparator(), subnames), new String[0]);
    }

    @Override
    public boolean startsWith(Path path) {
        if (!path.getFileSystem().equals(this.parentFileSystem)) {
            return false;
        }
        if (this.pathString.isEmpty() ^ ((AzurePath)path).pathString.isEmpty()) {
            return false;
        }
        String[] thisPathElements = this.splitToElements();
        String[] otherPathElements = ((AzurePath)path).splitToElements();
        if (otherPathElements.length > thisPathElements.length) {
            return false;
        }
        for (int i = 0; i < otherPathElements.length; ++i) {
            if (otherPathElements[i].equals(thisPathElements[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean startsWith(String path) {
        return this.startsWith(this.parentFileSystem.getPath(path, new String[0]));
    }

    @Override
    public boolean endsWith(Path path) {
        if (path.getFileSystem() != this.parentFileSystem) {
            return false;
        }
        if (this.pathString.isEmpty() ^ ((AzurePath)path).pathString.isEmpty()) {
            return false;
        }
        String[] thisPathElements = this.splitToElements();
        String[] otherPathElements = ((AzurePath)path).splitToElements();
        if (otherPathElements.length > thisPathElements.length) {
            return false;
        }
        if (path.getRoot() != null && otherPathElements.length != thisPathElements.length) {
            return false;
        }
        for (int i = 1; i <= otherPathElements.length; ++i) {
            if (otherPathElements[otherPathElements.length - i].equals(thisPathElements[thisPathElements.length - i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(String path) {
        return this.endsWith(this.parentFileSystem.getPath(path, new String[0]));
    }

    @Override
    public Path normalize() {
        ArrayDeque<String> stack = new ArrayDeque<String>();
        String[] pathElements = this.splitToElements();
        Path root = this.getRoot();
        String rootStr = root == null ? null : root.toString();
        for (String element : pathElements) {
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                if (rootStr != null) {
                    if (!stack.isEmpty() && ((String)stack.peekLast()).equals(rootStr)) continue;
                    stack.removeLast();
                    continue;
                }
                if (stack.isEmpty()) {
                    stack.addLast(element);
                    continue;
                }
                if (((String)stack.peek()).equals("..")) {
                    stack.addLast(element);
                    continue;
                }
                stack.removeLast();
                continue;
            }
            stack.addLast(element);
        }
        return this.parentFileSystem.getPath("", stack.toArray(new String[0]));
    }

    @Override
    public Path resolve(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        if (path.getNameCount() == 0) {
            return this;
        }
        return this.parentFileSystem.getPath(this.toString(), path.toString());
    }

    @Override
    public Path resolve(String path) {
        return this.resolve(this.parentFileSystem.getPath(path, new String[0]));
    }

    @Override
    public Path resolveSibling(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        Path parent = this.getParent();
        return parent == null ? path : parent.resolve(path);
    }

    @Override
    public Path resolveSibling(String path) {
        return this.resolveSibling(this.parentFileSystem.getPath(path, new String[0]));
    }

    @Override
    public Path relativize(Path path) {
        int i;
        if (path.getRoot() == null ^ this.getRoot() == null) {
            throw LoggingUtility.logError(LOGGER, new IllegalArgumentException("Both paths must be absolute or neither can be"));
        }
        AzurePath thisNormalized = (AzurePath)this.normalize();
        Path otherNormalized = path.normalize();
        ArrayDeque<String> deque = new ArrayDeque<String>(Arrays.asList(otherNormalized.toString().split(this.parentFileSystem.getSeparator())));
        String[] thisElements = thisNormalized.splitToElements();
        for (i = 0; i < thisElements.length && !deque.isEmpty() && thisElements[i].equals(deque.peekFirst()); ++i) {
            deque.removeFirst();
        }
        while (i < thisElements.length) {
            deque.addFirst("..");
            ++i;
        }
        return this.parentFileSystem.getPath("", deque.toArray(new String[0]));
    }

    @Override
    public URI toUri() {
        try {
            return new URI(this.parentFileSystem.provider().getScheme(), null, "/" + this.toAbsolutePath(), null, null);
        }
        catch (URISyntaxException e) {
            throw LoggingUtility.logError(LOGGER, new IllegalStateException("Unable to create valid URI from path", e));
        }
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return this.parentFileSystem.getDefaultDirectory().resolve(this);
    }

    @Override
    public Path toRealPath(LinkOption ... linkOptions) throws IOException {
        throw new UnsupportedOperationException("Symbolic links are not supported.");
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watchService, WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException("WatchEvents are not supported.");
    }

    @Override
    public WatchKey register(WatchService watchService, WatchEvent.Kind<?> ... kinds) throws IOException {
        throw new UnsupportedOperationException("WatchEvents are not supported.");
    }

    @Override
    public Iterator<Path> iterator() {
        if (this.pathString.isEmpty()) {
            return Collections.singletonList(this).iterator();
        }
        return Arrays.asList((Path[])Stream.of(this.splitToElements(this.withoutRoot())).map(s -> this.parentFileSystem.getPath((String)s, new String[0])).toArray(Path[]::new)).iterator();
    }

    @Override
    public int compareTo(Path path) {
        if (!(path instanceof AzurePath)) {
            throw LoggingUtility.logError(LOGGER, new ClassCastException("Other path is not an instance of AzurePath."));
        }
        return this.pathString.compareTo(((AzurePath)path).pathString);
    }

    @Override
    public String toString() {
        return this.pathString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzurePath paths = (AzurePath)o;
        return Objects.equals(this.parentFileSystem, paths.parentFileSystem) && Objects.equals(this.pathString, paths.pathString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.parentFileSystem, this.pathString);
    }

    public BlobClient toBlobClient() throws IOException {
        Path root = this.normalize().toAbsolutePath().getRoot();
        if (root == null) {
            throw LoggingUtility.logError(LOGGER, new IllegalStateException("Root should never be null after calling toAbsolutePath."));
        }
        String fileStoreName = this.rootToFileStore(root.toString());
        BlobContainerClient containerClient = ((AzureFileStore)this.parentFileSystem.getFileStore(fileStoreName)).getContainerClient();
        String blobName = this.withoutRoot();
        if (blobName.isEmpty()) {
            throw LoggingUtility.logError(LOGGER, new IOException("Cannot get a blob client to a path that only contains the root or is an empty path"));
        }
        return containerClient.getBlobClient(blobName);
    }

    public static AzurePath fromBlobUrl(AzureFileSystemProvider provider, String url) throws URISyntaxException {
        BlobUrlParts parts = BlobUrlParts.parse((String)url);
        URI fileSystemUri = AzurePath.hostToFileSystemUri(provider, parts.getScheme(), parts.getHost());
        FileSystem parentFileSystem = provider.getFileSystem(fileSystemUri);
        return new AzurePath((AzureFileSystem)parentFileSystem, AzurePath.fileStoreToRoot(parts.getBlobContainerName()), parts.getBlobName() == null ? "" : parts.getBlobName());
    }

    boolean isRoot() {
        return this.equals(this.getRoot());
    }

    private String withoutRoot() {
        Path root = this.getRoot();
        String str = this.pathString;
        if (root != null) {
            str = this.pathString.substring(root.toString().length());
        }
        if (str.startsWith(this.parentFileSystem.getSeparator())) {
            str = str.substring(1);
        }
        return str;
    }

    private String[] splitToElements() {
        return this.splitToElements(this.pathString);
    }

    private String[] splitToElements(String str) {
        String[] arr = str.split(this.parentFileSystem.getSeparator());
        if (arr.length == 1 && arr[0].isEmpty()) {
            return new String[0];
        }
        return arr;
    }

    private String rootToFileStore(String root) {
        return root.substring(0, root.length() - 1);
    }

    private static String fileStoreToRoot(String fileStore) {
        if (fileStore == null || "".equals(fileStore)) {
            return "";
        }
        return fileStore + ROOT_DIR_SUFFIX;
    }

    private static URI hostToFileSystemUri(AzureFileSystemProvider provider, String scheme, String host) throws URISyntaxException {
        return new URI(provider.getScheme() + "://?endpoint=" + scheme + "://" + host);
    }

    static void ensureFileSystemOpen(Path p) {
        if (!p.getFileSystem().isOpen()) {
            throw LoggingUtility.logError(LOGGER, new ClosedFileSystemException());
        }
    }
}

