/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.rm;

import com.dbeaver.remote.client.BodyConverter;
import com.dbeaver.remote.client.rm.RMClientBase;
import com.dbeaver.remote.client.rm.RMClientConfiguration;
import java.lang.reflect.Type;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.task.DBTTaskController;

public class TaskControllerClient
extends RMClientBase
implements DBTTaskController {
    private static final String TASKS = "tasks";

    public TaskControllerClient(@NotNull RMClientConfiguration config) {
        super(config);
    }

    public String loadTaskConfigurationFile(@NotNull String projectId, @NotNull String filePath) throws DBException {
        return (String)this.executeGetRequest(TaskControllerClient.buildEndpointUrl((String[])new String[]{TASKS, projectId}), Map.of("filePath", filePath), BodyConverter.TEXT_PLAIN, (Type)((Object)String.class));
    }

    @Nullable
    public String loadTaskConfiguration(@NotNull String projectId, @NotNull String taskId, @NotNull String filePath) throws DBException {
        return (String)this.executeGetRequest(TaskControllerClient.buildEndpointUrl((String[])new String[]{TASKS, projectId, taskId}), Map.of("filePath", filePath), BodyConverter.TEXT_PLAIN, (Type)((Object)String.class));
    }

    public void saveTaskConfigurationFile(@NotNull String projectId, @NotNull String filePath, @Nullable String data) throws DBException {
        this.executePutRequest(TaskControllerClient.buildEndpointUrl((String[])new String[]{TASKS, projectId}), Map.of("filePath", filePath), data, BodyConverter.TEXT_PLAIN, (Type)((Object)Void.class));
    }
}

