/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.rm;

import com.dbeaver.remote.client.rm.FileControllerClient;
import com.dbeaver.remote.client.rm.RMClientConfiguration;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBFileController;

public class RemoteFileController
implements DBFileController {
    private final FileControllerClient fcClient;

    public RemoteFileController(RMClientConfiguration rmClientConfiguration) {
        this.fcClient = new FileControllerClient(rmClientConfiguration);
    }

    public byte[] loadFileData(@NotNull String fileType, @NotNull String filePath) throws DBException {
        return this.fcClient.loadFileData(fileType, this.normalizePath(filePath));
    }

    public void saveFileData(@NotNull String fileType, @NotNull String filePath, byte[] fileData) throws DBException {
        this.fcClient.saveFileData(fileType, this.normalizePath(filePath), fileData);
    }

    public String[] listFiles(@NotNull String fileType, @NotNull String filePath) throws DBException {
        return this.fcClient.listFiles(fileType, this.normalizePath(filePath));
    }

    public void deleteFile(@NotNull String fileType, @NotNull String filePath, boolean recursive) throws DBException {
        this.fcClient.deleteFile(fileType, this.normalizePath(filePath), recursive);
    }

    @NotNull
    private String normalizePath(@NotNull String filePath) {
        return filePath.replace("\\", "/");
    }
}

