/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.rm;

import com.dbeaver.model.DBSecureConfigurationController;
import com.dbeaver.remote.client.BodyConverter;
import com.dbeaver.remote.client.rm.RMClientBase;
import com.dbeaver.remote.client.rm.RMClientConfiguration;
import java.lang.reflect.Type;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBConfigurationController;

public class ConfigurationControllerClient
extends RMClientBase
implements DBConfigurationController,
DBSecureConfigurationController {
    public ConfigurationControllerClient(RMClientConfiguration config) {
        super(config);
    }

    public String loadConfigurationFile(@NotNull String filePath) throws DBException {
        Map params = Map.of();
        return (String)this.executeGetRequest(ConfigurationControllerClient.buildEndpointUrl((String[])new String[]{"config-files", ConfigurationControllerClient.encodePath(filePath)}), params, BodyConverter.TEXT_PLAIN, (Type)((Object)String.class));
    }

    public void saveConfigurationFile(@NotNull String filePath, @NotNull String data) throws DBException {
        Map params = Map.of();
        this.executePutRequest(ConfigurationControllerClient.buildEndpointUrl((String[])new String[]{"config-files", ConfigurationControllerClient.encodePath(filePath)}), params, data, BodyConverter.TEXT_PLAIN, (Type)((Object)String.class));
    }

    public String loadSecureConfigurationFile(@NotNull String filePath) throws DBException {
        Map params = Map.of();
        return (String)this.executeGetRequest(ConfigurationControllerClient.buildEndpointUrl((String[])new String[]{"secure-config-files", ConfigurationControllerClient.encodePath(filePath)}), params, BodyConverter.TEXT_PLAIN, (Type)((Object)String.class));
    }

    public void saveSecureConfigurationFile(@NotNull String filePath, @NotNull String data) throws DBException {
        Map params = Map.of();
        this.executePutRequest(ConfigurationControllerClient.buildEndpointUrl((String[])new String[]{"secure-config-files", ConfigurationControllerClient.encodePath(filePath)}), params, data, BodyConverter.TEXT_PLAIN, (Type)((Object)String.class));
    }

    private static String encodePath(String filePath) {
        return filePath.replace('/', '|');
    }
}

