/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application.security;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.secret.DBSSecret;
import org.jkiss.dbeaver.model.secret.DBSSecretBrowser;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.secret.DBSSecretObject;
import org.jkiss.dbeaver.model.secret.DBSSecretValue;
import org.jkiss.dbeaver.runtime.DBSecurityException;

public class SecurePreferencesSecretController
implements DBSSecretController,
DBSSecretBrowser {
    public static final String SECRET_PREFS_ROOT = "dbeaver";
    public static final SecurePreferencesSecretController INSTANCE = new SecurePreferencesSecretController("");
    private final Path root;

    private SecurePreferencesSecretController(String root) {
        this.root = Path.of(root, new String[0]);
    }

    @Nullable
    public String getPrivateSecretValue(@NotNull String secretId) throws DBException {
        try {
            Path keyPath = this.root.resolve(this.escapeSecretKey(secretId));
            return SecurePreferencesSecretController.getNodeByPath(keyPath.getParent()).get(keyPath.getFileName().toString(), null);
        }
        catch (StorageException e) {
            if (e.getErrorCode() == 4) {
                throw new DBSecurityException("Cannot load secure settings - master password is not provided");
            }
            throw new DBSecurityException("Error getting preference value '" + secretId + "'", (Throwable)e);
        }
    }

    public void setPrivateSecretValue(@NotNull String secretId, @Nullable String secretValue) throws DBException {
        try {
            Path keyPath = this.root.resolve(this.escapeSecretKey(secretId));
            ISecurePreferences node = SecurePreferencesSecretController.getNodeByPath(keyPath.getParent());
            if (secretValue != null) {
                node.put(keyPath.getFileName().toString(), secretValue, true);
            } else {
                node.remove(keyPath.getFileName().toString());
            }
        }
        catch (StorageException e) {
            if (e.getErrorCode() == 4) {
                throw new DBSecurityException("Cannot save secure settings - password is invalid or was not provided", (Throwable)e);
            }
            throw new DBSecurityException("Error setting preference value '" + secretId + "'", (Throwable)e);
        }
    }

    @NotNull
    public List<DBSSecretValue> discoverCurrentUserSecrets(@NotNull DBSSecretObject secretObject) throws DBException {
        throw new DBCFeatureNotSupportedException("Secrets discovery not supported");
    }

    public void flushChanges() throws DBException {
        try {
            SecurePreferencesFactory.getDefault().flush();
        }
        catch (IOException e) {
            throw new DBException("Error flushing secure preferences", (Throwable)e);
        }
    }

    private static ISecurePreferences getNodeByPath(Path path) {
        ISecurePreferences rootNode = SecurePreferencesFactory.getDefault().node(SECRET_PREFS_ROOT);
        if (path != null) {
            for (Path name : path) {
                rootNode = rootNode.node(name.toString());
            }
        }
        return rootNode;
    }

    @NotNull
    public List<DBSSecret> listSecrets(@Nullable String path) throws DBException {
        Path keyPath = path == null ? this.root : this.root.resolve(this.escapeSecretKey(path));
        return Arrays.stream(SecurePreferencesSecretController.getNodeByPath(keyPath).keys()).map(k -> new DBSSecret(keyPath.resolve(this.escapeSecretKey((String)k)).toString(), k)).collect(Collectors.toList());
    }

    @Nullable
    public DBSSecret getSecret(@NotNull String secretId) throws DBException {
        String keyId;
        Path keyPath;
        block3: {
            try {
                keyPath = this.root.resolve(this.escapeSecretKey(secretId));
                keyId = keyPath.getFileName().toString();
                String value = SecurePreferencesSecretController.getNodeByPath(keyPath.getParent()).get(keyId, null);
                if (value != null) break block3;
                return null;
            }
            catch (StorageException e) {
                throw new DBSecurityException("Error getting secret info '" + secretId + "'", (Throwable)e);
            }
        }
        return new DBSSecret(keyPath.toString(), keyId);
    }

    public void deleteSecret(@NotNull String secretId) throws DBException {
        throw new DBCFeatureNotSupportedException();
    }

    public void clearAllSecrets(String keyPrefix) throws DBException {
        SecurePreferencesSecretController.getNodeByPath(this.root.resolve(this.escapeSecretKey(keyPrefix))).removeNode();
    }

    private String escapeSecretKey(String key) {
        return key.replace(':', '_');
    }
}

