/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application.security;

import java.nio.file.Files;
import java.nio.file.Path;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.equinox.internal.security.storage.provider.IValidatingPasswordProvider;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.equinox.security.storage.provider.PasswordProvider;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.CommonUtils;

public class AutomationPasswordProvider
extends PasswordProvider
implements IValidatingPasswordProvider {
    private static final Log log = Log.getLog(AutomationPasswordProvider.class);
    public static final String ID = "AutomationPasswordProvider";
    private static final String ENV_VAR_PASSWORD = "DBEAVER_MASTER_PASSWORD";
    private static final String ENV_VAR_PASSWORD_PATH = "DBEAVER_MASTER_PASSWORD_PATH";
    private static final String DEFAULT_PASSWORD_VALUE = "dbeaver-console-password";

    public PBEKeySpec getPassword(IPreferencesContainer container, int passwordType) {
        String passwordPath;
        Object password = System.getenv(ENV_VAR_PASSWORD);
        if (CommonUtils.isEmpty((String)password) && !CommonUtils.isEmpty((String)(passwordPath = System.getenv(ENV_VAR_PASSWORD_PATH)))) {
            try {
                password = Files.readString(Path.of(passwordPath, new String[0]));
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        if (CommonUtils.isEmpty((String)password)) {
            String userName = System.getProperty("user.name");
            password = CommonUtils.isEmpty((String)userName) ? DEFAULT_PASSWORD_VALUE : "_" + userName.toUpperCase() + "_";
        }
        return new PBEKeySpec(((String)password).toCharArray());
    }

    public boolean isValid() {
        PBEKeySpec password = this.getPassword(null, 0);
        if (password == null) {
            log.debug((Object)"Automation password provider is disabled. Set variable DBEAVER_MASTER_PASSWORD or DBEAVER_MASTER_PASSWORD_PATH to enable it");
        }
        return password != null;
    }
}

