/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application.cli;

import com.dbeaver.application.cli.CustomVariables;
import com.dbeaver.application.cli.HeadlessTaskExecutor;
import com.dbeaver.lm.api.LMException;
import com.dbeaver.model.DBPApplicationEAP;
import com.dbeaver.model.license.app.DBPApplicationLicensed;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.AbstractCommandLineParameterHandler;
import org.jkiss.dbeaver.model.cli.CLIException;
import org.jkiss.dbeaver.model.cli.CLIProcessResult;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskRun;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="runTask", aliases={"-runTask", "-execute-task"}, description={"Executes the task with specified name. In multi-project environment task name must be in form @projectName:taskName."})
public class TaskParameterHandler
extends AbstractCommandLineParameterHandler {
    private static final Log log = Log.getLog(TaskParameterHandler.class);
    @CommandLine.Parameters(index="0", description={"Task name must be in form @projectName:taskName"}, arity="1")
    private String value;
    @CommandLine.Option(names={"-var", "-custom-variables"}, arity="1", description={"Set custom variable for task execution."})
    private List<String> variables;

    public void run() {
        DBPApplicationLicensed application = (DBPApplicationLicensed)((DBPApplicationEAP)DBWorkbench.getPlatform().getApplication());
        try {
            if (!application.getLicenseService().invalidateActiveLicense(false)) {
                return;
            }
        }
        catch (LMException e) {
            log.error((Object)e);
            return;
        }
        if (application.isEarlyAccessProgram()) {
            log.error((Object)"Task execution is not allowed when participating in Early Access Program");
            return;
        }
        if (!CommonUtils.isEmpty(this.variables)) {
            for (String variable : this.variables) {
                String valueName = "";
                String parameterValue = "";
                int sign = variable.indexOf("=");
                if (sign != -1) {
                    valueName = variable.substring(0, sign);
                    parameterValue = variable.substring(sign + 1);
                } else {
                    log.error((Object)("Custom variables pattern is incorrect: " + variable));
                }
                if (!CommonUtils.isNotEmpty((String)valueName) || !CommonUtils.isNotEmpty((String)parameterValue)) continue;
                CustomVariables.addCustomParameters(valueName.trim(), parameterValue.trim());
            }
        }
        Map<String, String> customParameters = CustomVariables.getCustomParameters();
        try {
            DBTTask task = HeadlessTaskExecutor.getInstance().runTask((DBRProgressMonitor)new LoggingProgressMonitor(), this.value, customParameters);
            DBTTaskRun taskRun = task.getLastRun();
            this.context().setPostAction(CLIProcessResult.PostAction.SHUTDOWN);
            if (taskRun != null && !taskRun.isRunSuccess()) {
                throw new CLIException(taskRun.getErrorMessage(), 1);
            }
        }
        catch (Exception e) {
            throw new CLIException("Error executing task '" + this.value + "': " + e.getMessage(), (Throwable)e, 1);
        }
    }
}

