/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application.cli;

import com.dbeaver.application.DBeaverApplicationAdvanced;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.app.standalone.rpc.IInstanceController;

public class HeadlessTaskExecutor {
    private static final Log log = Log.getLog(HeadlessTaskExecutor.class);
    private static final String TASK_LOG_PREFIX = "[TASK] ";
    private static HeadlessTaskExecutor instance;

    public static synchronized HeadlessTaskExecutor getInstance() {
        if (instance == null) {
            instance = new HeadlessTaskExecutor();
        }
        return instance;
    }

    @NotNull
    public DBTTask runTask(@NotNull DBRProgressMonitor monitor, String taskNameStr, Map<String, String> parameters) throws DBException {
        DBTTask task;
        DBPProject project;
        int divPos;
        String projectName = null;
        String taskName = taskNameStr;
        if (taskNameStr.startsWith("@") && (divPos = taskNameStr.indexOf(58)) != -1) {
            projectName = taskNameStr.substring(1, divPos);
            taskName = taskNameStr.substring(divPos + 1);
        }
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        if (projectName == null) {
            project = workspace.getActiveProject();
            if (project == null) {
                List allProjects = workspace.getProjects();
                DBPProject dBPProject = project = allProjects.isEmpty() ? null : (DBPProject)allProjects.get(0);
                if (project == null) {
                    throw new DBException("No projects found in workspace " + String.valueOf(workspace.getAbsolutePath()));
                }
            }
        } else {
            project = workspace.getProject(projectName);
            if (project == null) {
                throw new DBException("Project '" + projectName + "' not found in workspace " + String.valueOf(workspace.getAbsolutePath()));
            }
        }
        if ((task = project.getTaskManager().getTaskById(taskName)) == null) {
            task = project.getTaskManager().getTaskByName(taskName);
        }
        if (task == null) {
            throw new DBException("Task '" + taskName + "' not found in project '" + project.getName() + "'");
        }
        log.debug((Object)("[TASK] Execute task " + task.getName()));
        new LinkedHashMap();
        DBTTask finalTask = task;
        DBTTaskExecutionListener listener = new DBTTaskExecutionListener(){

            public void taskStarted(@Nullable DBTTask task) {
            }

            public void taskFinished(@Nullable DBTTask t, @Nullable Object result, @Nullable Throwable error, @Nullable Object settings) {
            }

            public void subTaskFinished(@Nullable DBTTask task, @Nullable Throwable error, @Nullable Object settings) {
            }
        };
        Object propValue = task.getProperties().get("taskVariables");
        if (propValue instanceof Map) {
            Map map = (Map)propValue;
            map.putAll(parameters);
        } else {
            task.getProperties().put("taskVariables", new LinkedHashMap<String, String>(parameters));
        }
        task.getProject().getTaskManager().runTask(monitor, task, listener);
        log.debug((Object)("[TASK] Task finished " + task.getName()));
        DBeaverApplicationAdvanced app = (DBeaverApplicationAdvanced)DBWorkbench.getPlatform().getApplication();
        IInstanceController controller = app.createInstanceClient();
        if (controller != null) {
            controller.fireGlobalEvent("taskExecuted", Map.of("project", finalTask.getProject().getName(), "taskId", finalTask.getId()));
        }
        return finalTask;
    }
}

