/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application;

import com.dbeaver.application.internal.AdvancedAppMessages;
import com.dbeaver.model.DBPApplicationEAP;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.impl.app.BaseProjectImpl;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskReferenceCollector;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;
import org.jkiss.dbeaver.registry.task.TaskManagerImpl;
import org.jkiss.dbeaver.registry.task.TaskRunJob;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;

public class EnterpriseTaskManagerImpl
extends TaskManagerImpl {
    private static final Log log = Log.getLog(EnterpriseTaskManagerImpl.class);

    public EnterpriseTaskManagerImpl(BaseProjectImpl projectMetadata, Path statisticsFolder) {
        super(projectMetadata, statisticsFolder);
    }

    @NotNull
    public DBTTaskRunStatus runTask(@NotNull DBRProgressMonitor monitor, @NotNull DBTTask task, @NotNull DBTTaskExecutionListener listener) throws DBException {
        this.ensureCanRunOrUpdateTask();
        return super.runTask(monitor, task, listener);
    }

    @NotNull
    public TaskRunJob scheduleTask(@NotNull DBTTask task, @NotNull DBTTaskExecutionListener listener) throws DBException {
        this.ensureCanRunOrUpdateTask();
        return super.scheduleTask(task, listener);
    }

    public void updateTaskConfiguration(@NotNull DBTTask task) throws DBException {
        if (ArrayUtils.contains((Object[])this.getProject().getTaskManager().getAllTasks(), (Object)task)) {
            this.ensureCanRunOrUpdateTask();
        } else {
            this.ensureCanCreateTask();
        }
        super.updateTaskConfiguration(task);
    }

    protected void cancelJobIfNeeded(@NotNull TaskRunJob job) {
        Duration elapsedTime = job.getElapsedTime();
        Duration maxExecutionTime = job.getTask().getMaxExecutionTime();
        if (maxExecutionTime.isPositive() && elapsedTime.compareTo(maxExecutionTime) > 0) {
            job.cancelByTimeout();
        }
    }

    private void ensureCanCreateTask() throws DBException {
        DBPApplicationEAP app;
        DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
        if (dBPApplication instanceof DBPApplicationEAP && !(app = (DBPApplicationEAP)dBPApplication).isEarlyAccessProgram()) {
            return;
        }
        if (this.countTasks() >= 5) {
            throw new DBException(MessageFormat.format(AdvancedAppMessages.eap_task_limit_exceeded_create_message, 5));
        }
    }

    private void ensureCanRunOrUpdateTask() throws DBException {
        DBPApplicationEAP app;
        DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
        if (dBPApplication instanceof DBPApplicationEAP && !(app = (DBPApplicationEAP)dBPApplication).isEarlyAccessProgram()) {
            return;
        }
        if (this.countTasks() > 5) {
            throw new DBException(MessageFormat.format(AdvancedAppMessages.eap_task_limit_exceeded_run_message, 5));
        }
    }

    private int countTasks() {
        return Arrays.stream(this.getProject().getTaskManager().getAllTasks()).mapToInt(EnterpriseTaskManagerImpl::countTasks).sum();
    }

    private static int countTasks(@NotNull DBTTask task) {
        DBTTaskHandler handler;
        try {
            handler = task.getType().createHandler();
        }
        catch (DBException e) {
            log.error((Object)"Error creating task handler", (Throwable)e);
            return 1;
        }
        if (handler instanceof DBTTaskReferenceCollector) {
            DBTTaskReferenceCollector collector = (DBTTaskReferenceCollector)handler;
            ArrayList references = new ArrayList();
            collector.collectTaskReferences(task, references);
            return references.size();
        }
        return 1;
    }
}

