/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DesktopUI;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystems;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.dialogs.ObjectBrowserDialog;
import org.jkiss.dbeaver.ui.navigator.project.FileSystemExplorerView;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DesktopUIPro
extends DesktopUI {
    private static final Log log = Log.getLog(DesktopUIPro.class);

    public void initialize() {
        super.initialize();
    }

    public DBNPathBase openFileSystemSelector(@NotNull String title, boolean folder, int style, boolean binary, String[] filterExt, String defaultValue) {
        Shell shell = UIUtils.getActiveWorkbenchShell();
        if (shell == null) {
            log.error((Object)"Cannot show file systems without a shell");
            return null;
        }
        if (!DBWorkbench.getPlatform().getApplication().hasProductFeature("multi-fs")) {
            this.showMessageBox("No remote systems", "Remote file system are not supported in this product", true);
            return null;
        }
        DBNFileSystems fileSystemsNode = FileSystemExplorerView.getFileSystemsNode();
        if (fileSystemsNode == null) {
            this.showMessageBox("No file systems", "File system root node not found", true);
            return null;
        }
        try {
            Object[] fsNodes = fileSystemsNode.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
            if (ArrayUtils.isEmpty((Object[])fsNodes)) {
                this.showMessageBox("No external file systems", "No external file systems were configured.\nGo to Preferences or to Cloud Explorer view to configure cloud file systems.", true);
                UIUtils.showPreferencesFor((Shell)shell, null, (String[])new String[]{"com.dbeaver.preferences.cloudManager"});
                fileSystemsNode.refreshNode((DBRProgressMonitor)new VoidProgressMonitor(), (Object)this);
                fsNodes = fileSystemsNode.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
                if (ArrayUtils.isEmpty((Object[])fsNodes)) {
                    return null;
                }
            }
        }
        catch (DBException e) {
            log.debug((Object)e);
        }
        DBNNode selectedNode = null;
        if (defaultValue != null) {
            try {
                selectedNode = (DBNNode)UIUtils.runWithMonitor(monitor -> {
                    monitor.beginTask("Locate file", 1);
                    monitor.subTask("Locate '" + defaultValue + "'");
                    try {
                        DBNPathBase dBNPathBase = fileSystemsNode.findNodeByPath(monitor, defaultValue);
                        return dBNPathBase;
                    }
                    finally {
                        monitor.done();
                    }
                });
            }
            catch (Exception e) {
                log.debug((Object)("Error finding node for path '" + defaultValue + "' - " + CommonUtils.getAllExceptionMessages((Throwable)e)));
            }
        }
        ArrayList<String> allExtensions = new ArrayList<String>();
        if (filterExt != null) {
            String[] stringArray = filterExt;
            int n = filterExt.length;
            int n2 = 0;
            while (n2 < n) {
                String maskList = stringArray[n2];
                String[] stringArray2 = maskList.split(";");
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String mask = stringArray2[n4];
                    String ext = IOUtils.getFileExtension((String)mask);
                    if (ext != null) {
                        allExtensions.add(ext);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        Predicate<String> extFilter = s -> {
            if (allExtensions.contains("*")) {
                return true;
            }
            if (!allExtensions.isEmpty()) {
                int i = s.lastIndexOf(46);
                if (i < 0) {
                    return false;
                }
                return allExtensions.contains(s.substring(i + 1).toLowerCase());
            }
            return true;
        };
        DBNNode object = ObjectBrowserDialog.selectObject((Shell)shell, (String)title, (DBNNode)fileSystemsNode, (DBNNode)selectedNode, (Class[])new Class[]{DBNPathBase.class}, (Class[])new Class[]{DBNPathBase.class}, null, extFilter);
        if (object instanceof DBNPathBase) {
            DBNPathBase path = (DBNPathBase)object;
            return path;
        }
        return null;
    }
}

