/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application;

import com.dbeaver.application.DesktopUIPro;
import com.dbeaver.application.DesktopWorkspaceAdvanced;
import com.dbeaver.application.EnterpriseVersionUpdateDialog;
import com.dbeaver.application.EnterpriseWorkbenchAdvisor;
import com.dbeaver.application.ProductBuildInfo;
import com.dbeaver.ee.qm.db.impl.QMEmbeddedService;
import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseManager;
import com.dbeaver.lm.api.LMLicenseType;
import com.dbeaver.model.DBPApplicationEAP;
import com.dbeaver.model.DBPApplicationExtended;
import com.dbeaver.model.ai.RAGEmbeddingStorage;
import com.dbeaver.model.ai.RAGStorageProvider;
import com.dbeaver.model.ai.rag.storage.RAGDatabaseConfiguration;
import com.dbeaver.model.ai.rag.storage.RAGEmbeddingStorageFactory;
import com.dbeaver.model.license.DBPLicenseService;
import com.dbeaver.model.license.app.DBPApplicationLicensed;
import com.dbeaver.model.license.embedded.LicenseServiceEmbedded;
import com.dbeaver.model.qm.QMService;
import com.dbeaver.model.security.DBPasswordValidator;
import com.dbeaver.model.security.DefaultPasswordValidator;
import com.dbeaver.model.security.truststore.LocalTrustStoreController;
import com.dbeaver.ui.security.PasswordProviderUtils;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.Security;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPWorkspaceDesktop;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;
import org.jkiss.dbeaver.model.impl.app.ApplicationDescriptor;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;
import org.jkiss.dbeaver.model.qm.QMSessionProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.ApplicationPolicyProvider;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.net.DefaultCallbackHandler;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.runtime.ui.console.ConsoleUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.ApplicationWorkbenchAdvisor;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverApplication;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.osgi.framework.Version;

public class DBeaverApplicationAdvanced
extends DBeaverApplication
implements DBPApplicationExtended,
DBPApplicationLicensed,
DBPApplicationEAP,
QMSessionProvider,
RAGStorageProvider {
    private static final Log log = Log.getLog(DBeaverApplicationAdvanced.class);
    private static final String JAVA_DEFAULT_CALLBACK_HANDLER = "auth.login.defaultCallbackHandler";
    public static final String LICENSE_TYPE = "License-Type";
    private DBPLicenseService licenseService;
    private DBPasswordValidator passwordValidator;
    private String qmSessionId;
    private final ProductBuildInfo productBuildInfo = new ProductBuildInfo();
    private volatile Boolean isEAP;

    protected DBeaverApplicationAdvanced() {
    }

    protected DBeaverApplicationAdvanced(String defaultWorkspaceLocation, String defaultAppWorkspaceName, String defaultWorkspacesFile) {
        super(defaultWorkspaceLocation, defaultAppWorkspaceName, defaultWorkspacesFile);
    }

    public Class<? extends DBPPlatformUI> getPlatformUIClass() {
        return this.isHeadlessMode() ? ConsoleUserInterface.class : DesktopUIPro.class;
    }

    @NotNull
    public Map<String, String> getAdditionalApplicationProperties() {
        String licenseType = this.getLicenseType();
        if (licenseType != null) {
            return Map.of(LICENSE_TYPE, licenseType);
        }
        return Map.of();
    }

    @NotNull
    public RAGEmbeddingStorage getEmbeddingStorage() throws DBException {
        String url = "jdbc:sqlite:" + String.valueOf(DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve("rag_db.sqlite"));
        RAGDatabaseConfiguration configuration = new RAGDatabaseConfiguration();
        configuration.setDriver(RAGDatabaseConfiguration.SQLITE_DRIVER_ID.shortId());
        configuration.setUrl(url);
        return RAGEmbeddingStorageFactory.INSTANCE.createStorage(configuration);
    }

    protected void initializeApplication() {
        super.initializeApplication();
        LocalTrustStoreController.INSTANCE.changeTrustStoreIfNeeded();
        Security.setProperty(JAVA_DEFAULT_CALLBACK_HANDLER, DefaultCallbackHandler.class.getName());
        PasswordProviderUtils.initializePasswordProviders();
        ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
        ArrayList<String> applicableProductList = new ArrayList<String>();
        applicableProductList.add(application.getLicenseProductId());
        Collections.addAll(applicableProductList, application.getUmbrellaProductIds());
        for (String productId : applicableProductList) {
            this.addLicenseFiles("." + productId + "-license.dat");
            this.addLicenseFiles("." + productId + "-license.txt");
        }
    }

    protected void initializeApplicationServices() {
        super.initializeApplicationServices();
    }

    private void addLicenseFiles(String licenseFileName) {
        Path workspaceLicenseFile;
        Path userLicenseFile;
        String userHome = System.getProperty("user.home");
        if (userHome != null && Files.exists(userLicenseFile = Path.of(userHome, new String[0]).resolve(licenseFileName), new LinkOption[0])) {
            LMLicenseManager.addLicenseSearchPath((Path)userLicenseFile);
        }
        if (Files.exists(workspaceLicenseFile = GeneralUtils.getMetadataFolder().resolve(licenseFileName), new LinkOption[0])) {
            LMLicenseManager.addLicenseSearchPath((Path)workspaceLicenseFile);
        }
    }

    @NotNull
    public DBPWorkspaceDesktop createWorkspace(@NotNull DBPPlatform platform) {
        return new DesktopWorkspaceAdvanced(platform, this.loadEclipseWorkspace());
    }

    public void beforeWorkspaceInitialization() {
        try {
            LocalTrustStoreController.INSTANCE.initializeTrustStore((DBPApplication)this);
        }
        catch (Exception e) {
            log.error((Object)"Error initializing trust store", (Throwable)e);
        }
        super.beforeWorkspaceInitialization();
    }

    @NotNull
    protected ApplicationWorkbenchAdvisor createWorkbenchAdvisor() {
        return new EnterpriseWorkbenchAdvisor((DBPApplication)this);
    }

    public String getInfoDetails(DBRProgressMonitor monitor) {
        LMLicense license;
        block3: {
            try {
                license = this.getLicenseService().getActiveProductLicense(false);
                if (license != null) break block3;
                return "Not licensed! ";
            }
            catch (LMException e) {
                log.error((Object)"Error reading product license", (Throwable)e);
                return null;
            }
        }
        return "Licensed to " + license.getOwnerFull() + "\nLicense ID: " + license.getLicenseId();
    }

    public void notifyVersionUpgrade(@NotNull Version currentVersion, @NotNull VersionDescriptor newVersion, boolean showSkip) {
        EnterpriseVersionUpdateDialog dialog = new EnterpriseVersionUpdateDialog(UIUtils.getActiveWorkbenchShell(), currentVersion, newVersion, showSkip);
        dialog.open();
    }

    public boolean isLicenseRequired() {
        return true;
    }

    @NotNull
    public synchronized DBPLicenseService getLicenseService() {
        if (this.licenseService == null) {
            this.licenseService = this.createLicenseService();
        }
        return this.licenseService;
    }

    @NotNull
    public synchronized DBPasswordValidator getPasswordValidator() {
        if (this.passwordValidator == null) {
            try {
                ApplicationPolicyProvider provider = ApplicationPolicyProvider.getInstance();
                Object contents = provider.getPolicyValue("policy.master.password.policy");
                if (contents != null) {
                    this.passwordValidator = DefaultPasswordValidator.fromJson((Reader)new StringReader(contents.toString()));
                }
            }
            catch (Exception e) {
                log.error((Object)"Error initializing password validator", (Throwable)e);
            }
        }
        if (this.passwordValidator == null) {
            this.passwordValidator = NoOpPasswordValidator.INSTANCE;
        }
        return this.passwordValidator;
    }

    protected DBPLicenseService createLicenseService() {
        return new LicenseServiceEmbedded();
    }

    public boolean hasProductFeature(@NotNull String featureName) {
        if (featureName.equals("connection/simpleTruststore")) {
            return false;
        }
        return super.hasProductFeature(featureName);
    }

    public QMService getQueryManagerService() {
        return new QMEmbeddedService();
    }

    @NotNull
    public List<Path> getCertificatesRootFolders() {
        return List.of(Path.of(RuntimeUtils.getWorkingDirectory((String)"DBeaverData"), new String[0]).resolve("secure"));
    }

    public QMService getQueryManagerService(@NotNull SMCredentialsProvider credentialsProvider) {
        return this.getQueryManagerService();
    }

    @Nullable
    public String getQueryManagerSessionId() {
        return this.qmSessionId;
    }

    public synchronized void setQmSessionId(@NotNull String qmSessionId) {
        this.qmSessionId = qmSessionId;
    }

    public boolean isCommunity() {
        return false;
    }

    public boolean isWorkspaceSwitchingAllowed() {
        return !this.isEarlyAccessProgram();
    }

    public boolean isStatisticsCollectionRequired() {
        return this.isEarlyAccessProgram();
    }

    @NotNull
    public LocalDateTime getBuildDate() {
        if (this.isEarlyAccessBuild()) {
            return Objects.requireNonNull(this.productBuildInfo.getBuildDate());
        }
        throw new IllegalArgumentException("The build date is not assigned for non-Early Access builds.");
    }

    public boolean isEarlyAccessBuild() {
        return this.productBuildInfo.isEarlyAccessBuild();
    }

    public boolean isEarlyAccessProgram() {
        if (!this.isEarlyAccessBuild()) {
            this.isEAP = false;
        }
        if (this.isEAP == null) {
            try {
                DBPLicenseService dBPLicenseService;
                LMLicense license = this.getLicenseService().getActiveProductLicense(false);
                this.isEAP = license != null && license.getLicenseType() == LMLicenseType.EAP;
                if (!this.isEAP.booleanValue() && (dBPLicenseService = this.getLicenseService()) instanceof LicenseServiceEmbedded) {
                    LicenseServiceEmbedded licenseServiceEmbedded = (LicenseServiceEmbedded)dBPLicenseService;
                    licenseServiceEmbedded.getLicenseManager().clearLicensesCache();
                }
            }
            catch (LMException e) {
                log.warn((Object)"Error reading product license", (Throwable)e);
                this.isEAP = false;
            }
        }
        return this.isEAP;
    }

    @Nullable
    private String getLicenseType() {
        try {
            LMLicense license = this.getLicenseService().getActiveProductLicense(false);
            if (license != null) {
                return license.getLicenseType().name();
            }
            return null;
        }
        catch (LMException e) {
            log.warn((Object)"Error reading product license", (Throwable)e);
            return null;
        }
    }

    private static class NoOpPasswordValidator
    implements DBPasswordValidator {
        public static final NoOpPasswordValidator INSTANCE = new NoOpPasswordValidator();

        private NoOpPasswordValidator() {
        }

        public void validate(@NotNull String password) {
        }
    }
}

