/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.ui.ai.wizard;

import com.dbeaver.data.transfer.ui.ai.wizard.DTTargetTypeResolver;
import com.dbeaver.data.transfer.ui.ai.wizard.EEMappingRulesDialog;
import com.dbeaver.data.transfer.ui.ai.wizard.MappingMode;
import com.dbeaver.model.ai.prompt.dt.DTTContainer;
import com.dbeaver.ui.ai.messages.AIUIAdvancedMessages;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AICompletionSettings;
import org.jkiss.dbeaver.model.ai.AIContextSettings;
import org.jkiss.dbeaver.model.ai.AIIcons;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.ui.pages.database.DatabaseConsumerPageMapping;
import org.jkiss.dbeaver.tools.transfer.ui.pages.database.PreviewConsumer;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.AIUIUtils;
import org.jkiss.utils.CommonUtils;

public class EEDatabaseConsumerPageMapping
extends DatabaseConsumerPageMapping {
    private final DTTargetTypeResolver targetTypeResolver = new DTTargetTypeResolver();
    @Nullable
    private Button aiResolveButton;
    private final DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();

    public void createControl(Composite parent) {
        boolean aiEnabled;
        super.createControl(parent);
        boolean bl = aiEnabled = !AISettingsManager.getInstance().getSettings().isAiDisabled();
        if (aiEnabled) {
            this.aiResolveButton = this.createAIResolveButton(this.buttonsPanel);
            this.aiResolveButton.setEnabled(false);
            this.mappingRules.moveBelow((Control)this.aiResolveButton);
        }
        if (this.mappingRules != null) {
            Listener[] listenerArray = this.mappingRules.getListeners(13);
            int n = listenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listener = listenerArray[n2];
                this.mappingRules.removeListener(13, listener);
                ++n2;
            }
            this.mappingRules.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EEDatabaseConsumerPageMapping.this.openEEMappingRulesDialog();
                }
            });
        }
    }

    private void openEEMappingRulesDialog() {
        DBSObjectContainer container = this.getDatabaseConsumerSettings().getContainer();
        if (container == null) {
            return;
        }
        DBPDataSource dataSource = container.getDataSource();
        if (dataSource == null) {
            return;
        }
        List<Object> elementList = Arrays.stream(this.mappingViewer.getTree().getItems()).map(Widget::getData).toList();
        EEMappingRulesDialog dialog = new EEMappingRulesDialog(this.getShell(), dataSource, elementList);
        if (dialog.open() == 0) {
            this.mappingViewer.refresh();
            this.updateMappingsAndButtons();
            this.updatePageCompletion();
        }
    }

    protected void onMappingChanged(@NotNull SelectionChangedEvent event) {
        super.onMappingChanged(event);
        if (this.aiResolveButton != null) {
            this.aiResolveButton.setEnabled(this.hasMappings(this.getSelectedMapping()));
        }
    }

    @NotNull
    private Button createAIResolveButton(@NotNull Composite parent) {
        SelectionListener selectionListener = SelectionListener.widgetSelectedAdapter(event -> {
            try {
                DBPDataSourceContainer dbpDataSourceContainer;
                if (!AIUtils.hasValidConfiguration()) {
                    DBWorkbench.getPlatformUI().showError(AIUIAdvancedMessages.ai_popup_description_title, AIUIAdvancedMessages.ai_token_not_specified_message);
                    return;
                }
                DBSObjectContainer container = this.getDatabaseConsumerSettings().getContainer();
                if (container == null) {
                    DBWorkbench.getPlatformUI().showError(AIUIAdvancedMessages.ai_data_transfer_error_title, AIUIAdvancedMessages.ai_data_transfer_error_no_container);
                    return;
                }
                DBPDataSourceContainer dataSourceContainer = container instanceof DBPDataSourceContainer ? (dbpDataSourceContainer = (DBPDataSourceContainer)container) : container.getDataSource().getContainer();
                AICompletionSettings settings = new AICompletionSettings(dataSourceContainer);
                if (!AIUIUtils.confirmMetaTransfer((AIContextSettings)settings)) {
                    return;
                }
            }
            catch (DBException ex) {
                DBWorkbench.getPlatformUI().showError(AIUIAdvancedMessages.ai_data_transfer_error_title, AIUIAdvancedMessages.ai_data_transfer_error_config_check_failed, (Throwable)ex);
                return;
            }
            ((DataTransferWizard)this.getWizard()).runWithProgress(monitor -> {
                List<DTTContainer> containers = this.getDatabaseConsumerSettings().getDataMappings().values().stream().map(it -> new DTTContainer(it, maxRows -> this.getRows(monitor, (DatabaseMappingContainer)it, (int)maxRows))).toList();
                try {
                    MappingMode modeName = (MappingMode)CommonUtils.valueOf(MappingMode.class, (String)this.preferenceStore.getString("ai.mapping.mode"));
                    MappingMode mode = modeName == null ? MappingMode.ALL : modeName;
                    this.targetTypeResolver.resolve(monitor, this.getDatabaseConsumerSettings().getContainer(), containers, mode);
                }
                catch (DBException ex) {
                    DBWorkbench.getPlatformUI().showError("Failed to Resolve Target Type", "Failed to resolve target type for the selected container.", (Throwable)ex);
                }
            });
        });
        return UIUtils.createDialogButton((Composite)parent, (String)AIUIAdvancedMessages.ai_data_transfer_button_label, (DBPImage)AIIcons.AI, (String)AIUIAdvancedMessages.ai_data_transfer_button_tip, (SelectionListener)selectionListener);
    }

    @NotNull
    private List<Object[]> getRows(@NotNull DBRProgressMonitor monitor, @NotNull DatabaseMappingContainer container, int maxRows) throws DBException {
        DataTransferPipe pipe = this.getPipe(container);
        if (pipe == null) {
            return List.of();
        }
        DataTransferSettings dtSettings = ((DataTransferWizard)this.getWizard()).getSettings();
        PreviewConsumer previewConsumer = new PreviewConsumer(monitor, container, maxRows);
        IDataTransferConsumer originalConsumer = pipe.getConsumer();
        try {
            pipe.setConsumer((IDataTransferConsumer)previewConsumer);
            pipe.initPipe(dtSettings, 0, 1);
            IDataTransferProducer producer = pipe.getProducer();
            producer.transferData(previewConsumer.getCtlMonitor(), (IDataTransferConsumer)previewConsumer, dtSettings.getProcessor() == null ? null : dtSettings.getProcessor().getInstance(), dtSettings.getNodeSettings((IDataTransferNode)producer), null);
        }
        finally {
            pipe.setConsumer(originalConsumer);
            previewConsumer.close();
        }
        return previewConsumer.getRows();
    }
}

