/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.model.session;

import com.dbeaver.db.netezza.model.NetezzaDataSourceExt;
import com.dbeaver.db.netezza.model.session.NetezzaSession;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManagerSQL;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.utils.CommonUtils;

public class NetezzaSessionManager
implements DBAServerSessionManager<NetezzaSession>,
DBAServerSessionManagerSQL {
    public static final String PROP_ROLLBACK_TRANSACTION = "rollbackTrans";
    public static final String OPTION_JUST_ACTIVE = "justActive";
    private final NetezzaDataSourceExt dataSource;

    public NetezzaSessionManager(NetezzaDataSourceExt dataSource) {
        this.dataSource = dataSource;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public Collection<NetezzaSession> getSessions(@NotNull DBCSession session, @NotNull Map<String, Object> options) throws DBException {
        boolean showJustActive = CommonUtils.getOption(options, (String)OPTION_JUST_ACTIVE);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(this.generateSessionReadQuery(options));){
                ArrayList<NetezzaSession> arrayList;
                JDBCResultSet dbResult;
                Throwable throwable2;
                block22: {
                    throwable2 = null;
                    Object var8_12 = null;
                    dbResult = dbStat.executeQuery();
                    ArrayList<NetezzaSession> sessions = new ArrayList<NetezzaSession>();
                    while (dbResult.next()) {
                        NetezzaSession sessionInfo = new NetezzaSession((ResultSet)dbResult);
                        if (showJustActive && !"active".equals(sessionInfo.getState())) continue;
                        sessions.add(sessionInfo);
                    }
                    arrayList = sessions;
                    if (dbResult == null) break block22;
                    dbResult.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    public void alterSession(@NotNull DBCSession session, @NotNull String netezzaSession, @NotNull Map<String, Object> options) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(Boolean.TRUE.equals(options.get(PROP_ROLLBACK_TRANSACTION)) ? "ALTER SESSION " + netezzaSession + " ROLLBACK TRANSACTION" : "DROP SESSION " + netezzaSession);){
                dbStat.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    @NotNull
    public Map<String, Object> getTerminateOptions() {
        return Map.of(PROP_ROLLBACK_TRANSACTION, true);
    }

    public boolean canGenerateSessionReadQuery() {
        return true;
    }

    @NotNull
    public String generateSessionReadQuery(@NotNull Map<String, Object> options) {
        return "SHOW SESSION ALL";
    }
}

