/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.model;

import com.dbeaver.db.netezza.model.NetezzaDataSourceExt;
import com.dbeaver.db.netezza.model.NetezzaGenericProcedure;
import com.dbeaver.db.netezza.model.NetezzaGenericSequence;
import com.dbeaver.db.netezza.model.NetezzaGenericSynonym;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericExecutionContext;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructureAssistant;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.ArrayUtils;

public class NetezzaStructureAssistant
extends JDBCStructureAssistant<JDBCExecutionContext> {
    private final NetezzaDataSourceExt dataSource;
    private GenericCatalog catalog;
    private GenericSchema parentSchema;

    NetezzaStructureAssistant(NetezzaDataSourceExt dataSource) {
        this.dataSource = dataSource;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_VIEW, RelationalObjectType.TYPE_PROCEDURE, RelationalObjectType.TYPE_SEQUENCE, RelationalObjectType.TYPE_SYNONYM};
    }

    @NotNull
    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_VIEW, RelationalObjectType.TYPE_PROCEDURE, RelationalObjectType.TYPE_SYNONYM};
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext executionContext, @NotNull DBSStructureAssistant.ObjectsSearchParams params) throws DBException {
        ArrayList<DBSObjectReference> result = new ArrayList<DBSObjectReference>();
        this.initializeContainers(executionContext, params);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.META, "Find objects by mask");){
                Object[] objectTypes = params.getObjectTypes();
                if (ArrayUtils.contains((Object[])objectTypes, (Object)RelationalObjectType.TYPE_TABLE) || ArrayUtils.contains((Object[])objectTypes, (Object)RelationalObjectType.TYPE_VIEW)) {
                    this.findTablesAndViewsByMask(session, this.catalog, this.parentSchema, params, result);
                }
                if (ArrayUtils.contains((Object[])objectTypes, (Object)RelationalObjectType.TYPE_SEQUENCE)) {
                    this.findSequencesByMask(session, this.catalog, this.parentSchema, params, result);
                }
                if (ArrayUtils.contains((Object[])objectTypes, (Object)RelationalObjectType.TYPE_SYNONYM)) {
                    this.findSynonymsByMask(session, this.catalog, this.parentSchema, params, result);
                }
                if (ArrayUtils.contains((Object[])objectTypes, (Object)RelationalObjectType.TYPE_PROCEDURE)) {
                    this.findProceduresByMask(session, this.catalog, this.parentSchema, params, result);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            throw new DBDatabaseException((Throwable)ex, (DBPDataSource)this.dataSource);
        }
        return result;
    }

    protected void findObjectsByMask(@NotNull JDBCExecutionContext executionContext, @NotNull JDBCSession session, @NotNull DBSObjectType objectType, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> references) throws DBException, SQLException {
        this.initializeContainers(executionContext, params);
        if (objectType == RelationalObjectType.TYPE_TABLE || objectType == RelationalObjectType.TYPE_VIEW) {
            this.findTablesAndViewsByMask(session, this.catalog, this.parentSchema, params, references);
        }
        if (objectType == RelationalObjectType.TYPE_SEQUENCE) {
            this.findSequencesByMask(session, this.catalog, this.parentSchema, params, references);
        }
        if (objectType == RelationalObjectType.TYPE_SYNONYM) {
            this.findSynonymsByMask(session, this.catalog, this.parentSchema, params, references);
        }
        if (objectType == RelationalObjectType.TYPE_PROCEDURE) {
            this.findProceduresByMask(session, this.catalog, this.parentSchema, params, references);
        }
    }

    private void initializeContainers(@NotNull JDBCExecutionContext executionContext, @NotNull DBSStructureAssistant.ObjectsSearchParams params) {
        DBSObject parentObject = params.getParentObject();
        if (parentObject instanceof GenericCatalog) {
            this.catalog = (GenericCatalog)parentObject;
        } else {
            GenericSchema genericSchema = params.isGlobalSearch() ? null : (this.parentSchema = parentObject instanceof GenericSchema ? (GenericSchema)parentObject : null);
            if (this.parentSchema != null) {
                this.catalog = this.parentSchema.getCatalog();
            }
        }
        if (this.catalog == null && executionContext instanceof GenericExecutionContext) {
            this.catalog = ((GenericExecutionContext)executionContext).getDefaultCatalog();
        }
    }

    private void findTablesAndViewsByMask(@NotNull JDBCSession session, @Nullable GenericCatalog catalog, @Nullable GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> result) throws SQLException, DBException {
        List<DBSObjectType> objectTypesList = Arrays.asList(params.getObjectTypes());
        StringBuilder objectTypeClause = new StringBuilder(100);
        boolean addTables = objectTypesList.contains(RelationalObjectType.TYPE_TABLE);
        if (addTables) {
            objectTypeClause.append("'TABLE'");
        }
        if (objectTypesList.contains(RelationalObjectType.TYPE_VIEW)) {
            if (addTables) {
                objectTypeClause.append(",");
            }
            objectTypeClause.append("'VIEW'");
        }
        boolean searchInComments = params.isSearchInComments();
        String sql = "SELECT SCHEMA, OBJNAME, OBJTYPE, DESCRIPTION\nFROM " + (String)(catalog != null ? DBUtils.getQuotedIdentifier((DBSObject)catalog) + "." : "") + "DEFINITION_SCHEMA._V_OBJECTS WHERE " + (searchInComments ? "(" : "") + (params.isCaseSensitive() ? "OBJNAME" : "UPPER(OBJNAME)") + " LIKE ?";
        if (searchInComments) {
            sql = sql + " OR " + (params.isCaseSensitive() ? "DESCRIPTION" : "UPPER(DESCRIPTION)") + " LIKE ?)";
        }
        if (parentSchema != null) {
            sql = sql + " AND SCHEMA = ?";
        }
        sql = sql + " AND UPPER(OBJTYPE) IN (" + objectTypeClause.toString() + ")";
        sql = sql + "\nORDER BY SCHEMA, OBJNAME LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var13_14 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            String mask = params.getMask();
            if (!params.isCaseSensitive()) {
                mask = mask.toUpperCase();
            }
            dbStat.setString(1, mask);
            if (searchInComments) {
                dbStat.setString(2, mask);
            }
            if (parentSchema != null) {
                dbStat.setString(searchInComments ? 3 : 2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var17_20 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    String schemaName = dbResult.getString(1);
                    final String objectName = dbResult.getString(2);
                    final String tableType = dbResult.getString(3);
                    String description = dbResult.getString(4);
                    GenericSchema genericSchema = parentSchema != null ? parentSchema : (schema = catalog != null ? catalog.getSchema(monitor, schemaName) : this.dataSource.getSchema(schemaName));
                    if (schema == null) continue;
                    DBSObjectType objectType = RelationalObjectType.TYPE_TABLE;
                    if ("VIEW".equalsIgnoreCase(tableType)) {
                        objectType = RelationalObjectType.TYPE_VIEW;
                    }
                    result.add((DBSObjectReference)new AbstractObjectReference<GenericSchema>(objectName, schema, description, objectType.getClass(), objectType){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase tableBase = schema.getTable(monitor, objectName);
                            if (tableBase == null) {
                                throw new DBException(tableType + " '" + objectName + "' not found in schema '" + schema.getName() + "'");
                            }
                            return tableBase;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findSequencesByMask(@NotNull JDBCSession session, @Nullable GenericCatalog catalog, @Nullable GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> result) throws SQLException, DBException {
        String sql = "SELECT SCHEMA, SEQNAME FROM " + (String)(catalog != null ? DBUtils.getQuotedIdentifier((DBSObject)catalog) + "." : "") + "DEFINITION_SCHEMA._V_SEQUENCE\nWHERE " + (params.isCaseSensitive() ? "SEQNAME" : "UPPER(SEQNAME)") + " LIKE ?";
        if (parentSchema != null) {
            sql = sql + " AND SCHEMA = ?";
        }
        sql = sql + "\nORDER BY SCHEMA, SEQNAME LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            String mask = params.getMask();
            if (!params.isCaseSensitive()) {
                mask = mask.toUpperCase();
            }
            dbStat.setString(1, mask);
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    String schemaName = dbResult.getString(1);
                    final String objectName = dbResult.getString(2);
                    GenericSchema genericSchema = parentSchema != null ? parentSchema : (schema = catalog != null ? catalog.getSchema(monitor, schemaName) : this.dataSource.getSchema(schemaName));
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference<GenericSchema>(objectName, schema, null, NetezzaGenericSequence.class, RelationalObjectType.TYPE_SEQUENCE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericSequence object = ((GenericSchema)this.getContainer()).getSequence(monitor, objectName);
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)NetezzaStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            return object;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findSynonymsByMask(@NotNull JDBCSession session, @Nullable GenericCatalog catalog, @Nullable GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> result) throws SQLException, DBException {
        String sql = "SELECT SCHEMA, SYNONYM_NAME FROM " + (String)(catalog != null ? DBUtils.getQuotedIdentifier((DBSObject)catalog) + "." : "") + "DEFINITION_SCHEMA._V_SYNONYM\nWHERE " + (params.isCaseSensitive() ? "SYNONYM_NAME" : "UPPER(SYNONYM_NAME)") + " LIKE ?";
        if (parentSchema != null) {
            sql = sql + " AND SCHEMA = ?";
        }
        sql = sql + "\nORDER BY SCHEMA, SYNONYM_NAME LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            String mask = params.getMask();
            if (!params.isCaseSensitive()) {
                mask = mask.toUpperCase();
            }
            dbStat.setString(1, mask);
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    String schemaName = dbResult.getString(1);
                    final String objectName = dbResult.getString(2);
                    GenericSchema genericSchema = parentSchema != null ? parentSchema : (schema = catalog != null ? catalog.getSchema(monitor, schemaName) : this.dataSource.getSchema(schemaName));
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference<GenericSchema>(objectName, schema, null, NetezzaGenericSynonym.class, RelationalObjectType.TYPE_SYNONYM){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericSynonym synonym = ((GenericSchema)this.getContainer()).getSynonym(monitor, objectName);
                            if (synonym == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)NetezzaStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            return synonym;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findProceduresByMask(@NotNull JDBCSession session, @Nullable GenericCatalog catalog, @Nullable GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> result) throws SQLException, DBException {
        boolean searchInComments = params.isSearchInComments();
        String sql = "SELECT PROCEDURE, SCHEMA, PROCEDURESIGNATURE, DESCRIPTION FROM " + (String)(catalog != null ? DBUtils.getQuotedIdentifier((DBSObject)catalog) + "." : "") + "DEFINITION_SCHEMA._V_PROCEDURE\nWHERE " + (searchInComments ? "(" : "") + (params.isCaseSensitive() ? "PROCEDURE" : "UPPER(PROCEDURE)") + " LIKE ?";
        if (searchInComments) {
            sql = sql + " OR " + (params.isCaseSensitive() ? "DESCRIPTION" : "UPPER(DESCRIPTION)") + " LIKE ?)";
        }
        if (parentSchema != null) {
            sql = sql + " AND SCHEMA = ?";
        }
        sql = sql + "\nORDER BY SCHEMA, PROCEDURE LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            String mask = params.getMask();
            if (!params.isCaseSensitive()) {
                mask = mask.toUpperCase();
            }
            dbStat.setString(1, mask);
            if (searchInComments) {
                dbStat.setString(2, mask);
            }
            if (parentSchema != null) {
                dbStat.setString(searchInComments ? 3 : 2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var14_17 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    String procedureName = dbResult.getString(1);
                    String schemaName = dbResult.getString(2);
                    final String uniqueProcedureName = dbResult.getString(3);
                    String description = dbResult.getString(4);
                    GenericSchema genericSchema = parentSchema != null ? parentSchema : (schema = catalog != null ? catalog.getSchema(monitor, schemaName) : this.dataSource.getSchema(schemaName));
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference<GenericSchema>(procedureName, schema, description, NetezzaGenericProcedure.class, RelationalObjectType.TYPE_PROCEDURE, DBUtils.getQuotedIdentifier((DBSObject)schema) + "." + uniqueProcedureName){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericProcedure procedure = schema.getProcedure(monitor, uniqueProcedureName);
                            if (procedure == null) {
                                throw new DBException("Can't find procedure '" + uniqueProcedureName + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)NetezzaStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            return procedure;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public boolean supportsSearchInCommentsFor(@NotNull DBSObjectType objectType) {
        return objectType == RelationalObjectType.TYPE_TABLE || objectType == RelationalObjectType.TYPE_VIEW || objectType == RelationalObjectType.TYPE_PROCEDURE;
    }
}

