/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.model;

import com.dbeaver.db.netezza.model.NetezzaGenericDatabase;
import com.dbeaver.db.netezza.model.NetezzaStructureAssistant;
import com.dbeaver.db.netezza.model.NetezzaUserPasswordManager;
import com.dbeaver.db.netezza.model.plan.NetezzaExecutionPlan;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.ext.netezza.model.NetezzaDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAUserPasswordManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.CommonUtils;

public class NetezzaDataSourceExt
extends NetezzaDataSource
implements DBCQueryPlanner,
IAdaptable,
DBPObjectStatisticsCollector {
    private static final Log log = Log.getLog(NetezzaDataSourceExt.class);
    private boolean hasStatistics;

    public NetezzaDataSourceExt(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel);
    }

    public <T> T getAdapter(@NotNull Class<T> adapter) {
        if (adapter == DBAUserPasswordManager.class) {
            return adapter.cast(new NetezzaUserPasswordManager(this));
        }
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast((Object)new NetezzaStructureAssistant(this));
        }
        return (T)super.getAdapter(adapter);
    }

    public NetezzaDataSourceExt(@NotNull DBRProgressMonitor monitor, @NotNull GenericMetaModel metaModel, @NotNull DBPDataSourceContainer container) throws DBException {
        super(monitor, metaModel, container);
    }

    public List<String> getCatalogsNames(@NotNull DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData, @NotNull GenericMetaObject catalogObject, DBSObjectFilter catalogFilters) throws DBException {
        DBPConnectionConfiguration configuration = this.getContainer().getConnectionConfiguration();
        boolean showAllDatabases = CommonUtils.toBoolean((Object)configuration.getProviderProperty("show-all-databases@"));
        if (!showAllDatabases) {
            return Collections.singletonList(configuration.getDatabaseName());
        }
        return super.getCatalogsNames(monitor, metaData, catalogObject, catalogFilters);
    }

    protected boolean isPopulateClientAppName() {
        return false;
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query, @NotNull DBCQueryPlannerConfiguration configuration) throws DBException {
        NetezzaExecutionPlan plan = new NetezzaExecutionPlan((JDBCSession)session, query);
        plan.explain();
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.OUTPUT;
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public void collectObjectStatistics(@NotNull DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics && !forceRefresh) {
            return;
        }
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)("Load database '" + this.getName() + "' statistics"));){
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCStatement dbStat = session.createStatement();){
                        Throwable throwable3 = null;
                        Object var11_17 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery("SELECT\n\to.dbname AS DATABASENAME,\n\tSUM(z.ALLOCATED_BYTES) AS ALLOCATESPACE,\n\tSUM(z.Used_BYTES) AS USEDSPACE,\n\t(ALLOCATESPACE-USEDSPACE) AS FREESPACE\nFROM\n\tSYSTEM.DEFINITION_SCHEMA._V_SYS_OBJECT_STORAGE_SIZE z\nJOIN _v_object_data o ON\n\to.objid = z.tblid\nGROUP BY\n\to.dbname");){
                            while (dbResult.next()) {
                                String dbName = dbResult.getString(1);
                                NetezzaGenericDatabase netezzaDataBase = (NetezzaGenericDatabase)this.getCatalog(dbName);
                                if (netezzaDataBase == null) continue;
                                netezzaDataBase.fetchStatistics(dbResult);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBDatabaseException("Can't read database statistics", (Throwable)e, (DBPDataSource)this.getDataSource());
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }

    boolean showOwnerNamesForTables() {
        return CommonUtils.toBoolean((Object)this.getContainer().getConnectionConfiguration().getProviderProperty("switch-owner-name@"));
    }
}

