/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.nio;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.nio.NIOUtils;
import org.jkiss.utils.CommonUtils;

public abstract class NIOPath
implements Path {
    @Nullable
    protected final String path;
    protected final FileSystem fileSystem;

    protected NIOPath(@Nullable String path, FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        String separator = fileSystem.getSeparator();
        if (CommonUtils.isNotEmpty((String)path) && path.endsWith(separator)) {
            path = path.substring(0, path.length() - separator.length());
        }
        this.path = path;
    }

    @Override
    public boolean isAbsolute() {
        return CommonUtils.isEmpty((String)this.path) || this.path.charAt(0) == '/';
    }

    protected String resolveString(String otherPath) {
        return NIOUtils.resolve(this.getFileSystem().getSeparator(), this.path, otherPath);
    }

    protected String[] pathParts() {
        return CommonUtils.isEmpty((String)this.path) ? new String[]{} : (String[])Arrays.stream(this.path.split(this.getFileSystem().getSeparator())).filter(CommonUtils::isNotEmpty).toArray(String[]::new);
    }

    @Override
    public Path relativize(@NotNull Path other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(@NotNull Path other) {
        return this.toString().compareTo(other.toString());
    }

    @Override
    @NotNull
    public String toString() {
        return this.toUri().toString();
    }

    @Override
    public boolean startsWith(@NotNull Path other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.toString().startsWith(other.toString());
    }

    @Override
    public boolean endsWith(@NotNull Path other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.toString().endsWith(other.toUri().getPath());
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(@NotNull WatchService watcher, @NotNull WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }
}

