/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.model;

import com.dbeaver.db.redshift.model.RedshiftPermissionOwner;
import com.dbeaver.db.redshift.model.RedshiftUser;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class RedshiftGroup
extends RedshiftPermissionOwner {
    private static final Log log = Log.getLog(RedshiftGroup.class);
    private final List<RedshiftUser> groupUsers = new ArrayList<RedshiftUser>();

    public RedshiftGroup(PostgreDatabase database, String name) {
        super(database, name, null, false);
    }

    public RedshiftGroup(@NotNull DBRProgressMonitor monitor, @NotNull PostgreDatabase database, @NotNull ResultSet dbResult) throws SQLException {
        super(database, dbResult);
        this.loadInfo(monitor, dbResult);
    }

    protected void loadInfo(ResultSet dbResult) {
    }

    protected void loadInfo(@NotNull DBRProgressMonitor monitor, @NotNull ResultSet dbResult) {
        this.persisted = true;
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"grosysid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"groname");
        Object array = JDBCUtils.safeGetArray((ResultSet)dbResult, (String)"grolist");
        if (array instanceof Integer[]) {
            Integer[] usersIDs = (Integer[])array;
            try {
                Collection users = this.getDatabase().getUsers(monitor);
                Integer[] integerArray = usersIDs;
                int n = usersIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer id = integerArray[n2];
                    for (PostgreRole user : users) {
                        if (user.getObjectId() != (long)id.intValue()) continue;
                        this.groupUsers.add((RedshiftUser)user);
                    }
                    ++n2;
                }
            }
            catch (DBException dBException) {
                log.debug((Object)("Can't read users list for group " + this.name));
            }
        }
    }

    @Nullable
    public String getSpecificRoleType() {
        return "GROUP";
    }

    @Association
    public List<RedshiftUser> getGroupUsers() {
        return this.groupUsers;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        StringBuilder sql = new StringBuilder("CREATE GROUP " + DBUtils.getQuotedIdentifier((DBSObject)this));
        if (!CommonUtils.isEmpty(this.groupUsers)) {
            sql.append(" WITH USER ");
            StringJoiner joiner = new StringJoiner(",", " ", "");
            this.groupUsers.forEach(e -> {
                StringJoiner stringJoiner2 = joiner.add(DBUtils.getQuotedIdentifier((DBSObject)e));
            });
            sql.append(joiner);
        }
        sql.append(";");
        this.addPermissionsToDefinition(monitor, sql, options);
        return sql.toString();
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.groupUsers.clear();
        return super.refreshObject(monitor);
    }
}

