/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.json;

import com.dbeaver.jdbc.files.FFDataFileMetadataReader;
import com.dbeaver.jdbc.files.FFDataSourceScanner;
import com.dbeaver.jdbc.files.FFDataSourceScannerFactory;
import com.dbeaver.jdbc.files.FFDataSourceScannerImpl;
import com.dbeaver.jdbc.files.FFExternalMetadataReader;
import com.dbeaver.jdbc.files.FFExternalMetadataReaderImpl;
import com.dbeaver.jdbc.files.FFFileScannerFactory;
import com.dbeaver.jdbc.files.FFFileScannerImpl;
import com.dbeaver.jdbc.files.FFOrderMappingStrategy;
import com.dbeaver.jdbc.files.FFPropertiesFactory;
import com.dbeaver.jdbc.files.FFStructureMappingStrategy;
import com.dbeaver.jdbc.files.FFTableNameFactory;
import com.dbeaver.jdbc.files.FFTablePropertiesParser;
import com.dbeaver.jdbc.files.FFTableReaderFactory;
import com.dbeaver.jdbc.files.GenericTableNameFactory;
import com.dbeaver.jdbc.files.api.FFConnection;
import com.dbeaver.jdbc.files.api.FFDataSource;
import com.dbeaver.jdbc.files.api.FFDataSourceFormat;
import com.dbeaver.jdbc.files.api.FFDatabaseMetaData;
import com.dbeaver.jdbc.files.api.FFJdbcDriver;
import com.dbeaver.jdbc.files.database.FFDatabase;
import com.dbeaver.jdbc.files.json.JsonDatabaseMetaData;
import com.dbeaver.jdbc.files.json.JsonFileReaderFactory;
import com.dbeaver.jdbc.files.json.JsonMetadataReader;
import com.dbeaver.jdbc.files.json.JsonNode;
import com.dbeaver.jdbc.files.json.JsonProperties;
import com.dbeaver.jdbc.files.json.JsonTableProperties;
import com.dbeaver.jdbc.files.json.JsonTablePropertiesParser;
import com.dbeaver.jdbc.files.json.JsonTableReaderFactory;
import java.io.IOException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.jkiss.code.NotNull;

public class JsonJdbcDriver
extends FFJdbcDriver<JsonNode<?>, JsonTableProperties, JsonProperties> {
    public static final String DRIVER_NAME = "DBeaver JSON JDBC Driver";
    public static final String DRIVER_PREFIX = "jdbc:dbeaver:file:json:";
    public static final int DRIVER_VERSION_MAJOR = 1;
    public static final int DRIVER_VERSION_MINOR = 0;

    static {
        try {
            DriverManager.registerDriver((Driver)((Object)new JsonJdbcDriver()));
        }
        catch (SQLException e) {
            throw new RuntimeException("Error registering driver", e);
        }
    }

    public JsonJdbcDriver() {
        super(DRIVER_PREFIX, 1, 0);
    }

    @NotNull
    protected FFDatabaseMetaData createDatabaseMetaData(@NotNull FFConnection connection, @NotNull String url, @NotNull FFDatabase database) {
        return new JsonDatabaseMetaData(connection, url, database, this.getPropertiesFactory());
    }

    @NotNull
    public FFDataSourceFormat getSupportedDataSourceFormat() {
        return FFDataSourceFormat.JSON;
    }

    @NotNull
    public FFFileScannerFactory<JsonNode<?>, JsonTableProperties, JsonProperties> getFileScannerFactory() {
        return (dataSource, connectionClosedFuture) -> {
            JsonFileReaderFactory readerFactory = new JsonFileReaderFactory();
            return new FFFileScannerImpl((FFTableNameFactory)new GenericTableNameFactory(dataSource), (FFDataFileMetadataReader)new JsonMetadataReader((JsonProperties)dataSource.properties(), readerFactory), (FFExternalMetadataReader)new FFExternalMetadataReaderImpl((FFTablePropertiesParser)new JsonTablePropertiesParser()), (FFTableReaderFactory)new JsonTableReaderFactory(readerFactory, (JsonProperties)dataSource.properties()), (FFStructureMappingStrategy)new FFOrderMappingStrategy());
        };
    }

    @NotNull
    public FFDataSourceScannerFactory<JsonNode<?>, JsonTableProperties, JsonProperties> getDataSourceScannerFactory() {
        return new FFDataSourceScannerFactory<JsonNode<?>, JsonTableProperties, JsonProperties>(){

            @NotNull
            public FFDataSourceScanner<JsonNode<?>, JsonTableProperties, JsonProperties> createDataSourceScanner(@NotNull FFDataSource<JsonProperties> dataSource, @NotNull CompletableFuture<Void> connectionClosedFuture) throws IOException {
                return new FFDataSourceScannerImpl(JsonJdbcDriver.this.getFileScannerFactory().createScanner(dataSource, connectionClosedFuture));
            }
        };
    }

    @NotNull
    public FFPropertiesFactory<JsonProperties> getPropertiesFactory() {
        return new FFPropertiesFactory<JsonProperties>(){

            public JsonProperties createProperties(Properties properties) {
                return new JsonProperties(properties);
            }

            public JsonProperties createProperties(Map<String, String> properties) {
                return new JsonProperties(properties);
            }
        };
    }

    public String getDriverIdentifier() {
        return DRIVER_NAME;
    }
}

