/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.SetTableRemarksGenerator;
import liquibase.statement.core.SetTableRemarksStatement;
import liquibase.structure.DatabaseObject;
import org.apache.commons.lang3.StringUtils;

public class SetTableRemarksGeneratorDatabricks
extends SetTableRemarksGenerator {
    public boolean supports(SetTableRemarksStatement statement, Database database) {
        return database instanceof DatabricksDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public Sql[] generateSql(SetTableRemarksStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String remarksEscaped = database.escapeStringForDatabase(StringUtils.trimToEmpty((String)statement.getRemarks()));
        String sql = "COMMENT ON TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " IS '" + remarksEscaped + "'";
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedTable(statement)})};
    }
}

