/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.sqlgenerator;

import java.util.ArrayList;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.ext.databricks.change.createView.CreateViewStatementDatabricks;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.parser.LiquibaseSqlParser;
import liquibase.parser.SqlParserFactory;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateViewGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateViewStatement;
import liquibase.structure.DatabaseObject;
import org.apache.commons.lang3.StringUtils;

public class CreateViewGeneratorDatabricks
extends CreateViewGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(CreateViewStatement statement, Database database) {
        return super.supports((SqlStatement)statement, database) && database instanceof DatabricksDatabase;
    }

    public Sql[] generateSql(CreateViewStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ArrayList<UnparsedSql> sql = new ArrayList<UnparsedSql>();
        SqlParserFactory sqlParserFactory = (SqlParserFactory)Scope.getCurrentScope().getSingleton(SqlParserFactory.class);
        LiquibaseSqlParser sqlParser = sqlParserFactory.getSqlParser();
        String viewDefinition = sqlParser.parse(statement.getSelectQuery(), true, true).toString();
        if (!statement.isFullDefinition()) {
            viewDefinition = "CREATE VIEW " + database.escapeViewName(statement.getCatalogName(), statement.getSchemaName(), statement.getViewName()) + this.addTblProperties(statement) + " AS " + viewDefinition;
        }
        if (statement.isReplaceIfExists() && !statement.getSelectQuery().toUpperCase().contains("OR REPLACE")) {
            viewDefinition = viewDefinition.replace("CREATE", "CREATE OR REPLACE");
        }
        sql.add(new UnparsedSql(viewDefinition, new DatabaseObject[]{this.getAffectedView(statement)}));
        return sql.toArray(EMPTY_SQL);
    }

    private String addTblProperties(CreateViewStatement statement) {
        CreateViewStatementDatabricks thisStatement;
        if (statement instanceof CreateViewStatementDatabricks && StringUtils.isNotEmpty((CharSequence)(thisStatement = (CreateViewStatementDatabricks)statement).getTblProperties()) && !statement.getSelectQuery().toUpperCase().contains("TBLPROPERTIES")) {
            return " TBLPROPERTIES (" + thisStatement.getTblProperties() + ")";
        }
        return "";
    }
}

