/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.sqlgenerator;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext.databricks.change.createTable.CreateTableStatementDatabricks;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateTableGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateTableStatement;
import liquibase.structure.DatabaseObject;
import org.apache.commons.lang3.StringUtils;

public class CreateTableGeneratorDatabricks
extends CreateTableGenerator {
    private static final String[] PROPERTY_ORDER = new String[]{"'delta.feature.allowColumnDefaults'", "'delta.columnMapping.mode'", "'delta.enableDeletionVectors'"};
    private static final Map<String, String> DEFAULT_VALUES = Stream.of(new AbstractMap.SimpleEntry<String, String>("'delta.feature.allowColumnDefaults'", "'supported'"), new AbstractMap.SimpleEntry<String, String>("'delta.columnMapping.mode'", "'name'"), new AbstractMap.SimpleEntry<String, String>("'delta.enableDeletionVectors'", "true")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    public int getPriority() {
        return 5;
    }

    public boolean supports(CreateTableStatement statement, Database database) {
        return super.supports((SqlStatement)statement, database) && database instanceof DatabricksDatabase;
    }

    public ValidationErrors validate(CreateTableStatementDatabricks createStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        if (!createStatement.getPartitionColumns().isEmpty() && !createStatement.getClusterColumns().isEmpty()) {
            validationErrors.addError("WARNING! Databricks does not supported creating tables with PARTITION and CLUSTER columns, please one supply one option.");
        }
        return validationErrors;
    }

    private String mergeTableProperties(String customProperties) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(DEFAULT_VALUES);
        if (StringUtils.isNotEmpty((CharSequence)customProperties)) {
            Arrays.stream(customProperties.split(",")).map(String::trim).filter(prop -> !prop.isEmpty()).forEach(prop -> {
                String[] parts = prop.split("=", 2);
                if (parts.length == 2) {
                    properties.put(parts[0].trim(), parts[1].trim());
                }
            });
        }
        StringBuilder result = new StringBuilder();
        for (String key : PROPERTY_ORDER) {
            if (!properties.containsKey(key)) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(key).append(" = ").append((String)properties.get(key));
            properties.remove(key);
        }
        for (Map.Entry entry : properties.entrySet()) {
            if (entry.getValue() == null || ((String)entry.getValue()).equals("null")) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append((String)entry.getKey()).append(" = ").append((String)entry.getValue());
        }
        return result.toString();
    }

    public Sql[] generateSql(CreateTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        Sql[] sqls = super.generateSql(statement, database, sqlGeneratorChain);
        StringBuilder finalsql = new StringBuilder(sqls[0].toSql());
        if (statement instanceof CreateTableStatementDatabricks) {
            CreateTableStatementDatabricks thisStatement = (CreateTableStatementDatabricks)statement;
            if (!StringUtils.isEmpty((CharSequence)thisStatement.getTableFormat())) {
                finalsql.append(" USING ").append(thisStatement.getTableFormat());
            } else {
                finalsql.append(" USING delta");
            }
            String properties = null;
            if (thisStatement.getExtendedTableProperties() != null) {
                properties = thisStatement.getExtendedTableProperties().getTblProperties();
            }
            finalsql.append(" TBLPROPERTIES(").append(this.mergeTableProperties(properties)).append(")");
            if (!StringUtils.isEmpty((CharSequence)thisStatement.getTableLocation())) {
                finalsql.append(" LOCATION '").append(thisStatement.getTableLocation()).append("'");
            } else if (thisStatement.getExtendedTableProperties() != null && StringUtils.isNotEmpty((CharSequence)thisStatement.getExtendedTableProperties().getTableLocation())) {
                finalsql.append(" LOCATION '").append(thisStatement.getExtendedTableProperties().getTableLocation()).append("'");
            }
            List<String> clusterCols = thisStatement.getClusterColumns();
            List<String> partitionCols = thisStatement.getPartitionColumns();
            if (!clusterCols.isEmpty()) {
                finalsql.append(" CLUSTER BY (");
                int val = 0;
                while (clusterCols.size() > val) {
                    finalsql.append(clusterCols.get(val));
                    if (clusterCols.size() > ++val) {
                        finalsql.append(", ");
                        continue;
                    }
                    finalsql.append(")");
                }
            } else if (!partitionCols.isEmpty()) {
                finalsql.append(" PARTITIONED BY (");
                int val = 0;
                while (partitionCols.size() > val) {
                    finalsql.append(partitionCols.get(val));
                    if (partitionCols.size() > ++val) {
                        finalsql.append(", ");
                        continue;
                    }
                    finalsql.append(")");
                }
            }
        }
        sqls[0] = new UnparsedSql(finalsql.toString(), sqls[0].getAffectedDatabaseObjects().toArray(new DatabaseObject[0]));
        return sqls;
    }
}

